import { router, usePage } from "@inertiajs/react"
import { useState } from "react"

export function useBulkHandler(routeName, onSuccess) {
    const { props } = usePage()
    const statusEnum = props.statusEnum
    const [isBulkProcessing, setIsBulkProcessing] = useState(false)

    const handleBulkAction = (action, ids) => {
        setIsBulkProcessing(true)
        router.post(route(routeName), { action, ids }, {
            onSuccess: () => {
                onSuccess(action, ids, statusEnum)
                setIsBulkProcessing(false)
            },
            onError: () => setIsBulkProcessing(false),
        })
    }

    return { handleBulkAction, isBulkProcessing }
}
