"use client"

import AppLayout from "@/Layouts/AppLayout"
import { useState, useEffect } from "react"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/Components/UI/Tabs"
import { Button } from "@/Components/UI/Button"
import { Input } from "@/Components/UI/Input"
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from "@/Components/UI/DropdownMenu"
import { Grid3X3, List, Search, MoreVertical, Edit, Plus, Trash2, ChevronDown, FileText, Sparkles, Rocket } from "lucide-react"
import Pagination from "@/Components/UI/Pagination"
import { router } from "@inertiajs/react"
import DeleteModal from "@/Components/DeleteModal"
import { useDeleteHandler } from '@/hooks/useDeleteHandler';
import { route } from "ziggy-js"
import { Modal } from "@/Components/UI/Modal"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/Components/UI/Select"
import useTranslate from "@/hooks/useTranslate"


export default function TemplateIndex({ post_templates, platforms, ai_templates }) {
    const [viewMode, setViewMode] = useState("grid")
    const [searchQuery, setSearchQuery] = useState("")
    const [selectedPlatform, setSelectedPlatform] = useState("All Platform")
    const [activeTab, setActiveTab] = useState("post-template")
    const [currentPage, setCurrentPage] = useState(1)
    const [selectedTemplate, setSelectedTemplate] = useState(null)
    const [postTemplateList, setPostTemplateList] = useState(post_templates.data || [])
    const [aiTemplateList, setAiTemplateList] = useState(ai_templates.data || [])

    const [templateToDelete, setTemplateToDelete] = useState(null)
    const [aiTemplateToDelete, setAiTemplateToDelete] = useState(null)

    const [isDeleteTemplateModalOpen, setIsDeleteTemplateModalOpen] = useState(false)
    const [isDeleteAiTemplateModalOpen, setIsDeleteAiTemplateModalOpen] = useState(false)

    const [saveTemplateModalOpen, setSaveTemplateModalOpen] = useState(false)
    const [templatePrompt, setTemplatePrompt] = useState("")
    const [intendedPlatform, setIntendedPlatform] = useState(platforms.find(p => p.slug === "facebook")?.id || null)
    const [templateName, setTemplateName] = useState("")
    const [templateId, setTemplateId] = useState("")
    const [isSubmitting, setIsSubmitting] = useState(false)
    const t = useTranslate()

    useEffect(() => {
        setPostTemplateList(post_templates.data)
    }, [post_templates])

     useEffect(() => {
        setAiTemplateList(ai_templates.data)
    }, [ai_templates])


    const breadcrumbs = [{ label: "Home", href: route("user.home") }, { label: "Template" }]



    let filteredTemplates = [];

    if (activeTab === "post-template") {
        filteredTemplates = postTemplateList
    } else if (activeTab === "ai-template") {
        filteredTemplates = aiTemplateList
    }


    const handleTemplateAction = (action, template) => {

        switch (action) {
            case 'edit': handleEdit(template); break;
            case 'delete': handleDeleteTemplateClick(template); break;
        }
    }

    const handleAiTemplateAction = (action, template) => {

        switch (action) {
            case 'edit': handleAiEdit(template); break;
            case 'delete': handleDeleteAiTemplateClick(template); break;
        }
    }

    const handleEdit = (template) => {
        router.get(route("user.template.edit", template.id))
    }

    

    const handleDeleteTemplateClick = (template) => {
        setTemplateToDelete(template)
        setIsDeleteTemplateModalOpen(true)
    }

    const handleDeleteAiTemplateClick = (template) => {
        setAiTemplateToDelete(template)
        setIsDeleteAiTemplateModalOpen(true)
    }

    const { handleDelete: handleTemplateDelete, isDeleting: isTemplateDeleting } = useDeleteHandler('user.template.delete', (deletedId) => {
        setPostTemplateList((prev) => prev.filter((r) => r.id !== deletedId));
        setIsDeleteTemplateModalOpen(false);
        setTemplateToDelete(null);
    });


    const { handleDelete: handleAiTemplateDelete, isDeleting: isAiTemplateDeleting } = useDeleteHandler('user.template.ai.delete', (deletedId) => {
        setAiTemplateList((prev) => prev.filter((r) => r.id !== deletedId));
        setIsDeleteAiTemplateModalOpen(false);
        setAiTemplateToDelete(null);
    });

    const handleTemplateSelect = (template) => {
        setSelectedTemplate(selectedTemplate?.id === template.id ? null : template)
    }

    const handleSearch = (e) => {
        setSearchQuery(e.target.value)

        const platformId = platforms.find(p => p.slug === selectedPlatform)?.id

        router.get(
            route("user.template.index"),
            {
                search: searchQuery,
                platform_id: platformId,
                key : activeTab
            },
            {
                preserveState: true,
                preserveScroll: true,

            }
        );
    };

    const handlePlatformChnage = (platform) => {
        setSelectedPlatform(platform.slug)

        router.get(
            route("user.template.index"),
            {
                search: searchQuery,
                platform_id: platform.id,
                key : activeTab
            },
            {
                preserveState: true,
                preserveScroll: true,

            }
        );

    }

    const handleAiEdit = (template) => {
        setSaveTemplateModalOpen(true)
        setTemplateId(template.id)
        setTemplateName(template.name)
        setTemplatePrompt(template.prompt)

    }

    const handleSaveTemplate = (e) => {
        e.preventDefault()
        setIsSubmitting(true)
        router.post(route("user.template.ai.update"), {
            id : templateId ,
            name: templateName ?? "Ai Template",
            prompt: templatePrompt,
            platform_id: intendedPlatform
        },
            {
                onSuccess: () => {
                    setIsSubmitting(false)
                    setSaveTemplateModalOpen(false)
                },
                onError: () => {
                    setIsSubmitting(false)
                    setSaveTemplateModalOpen(false)
                }
            })

    }

    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <div className="flex-1 p-6 overflow-auto bg-gray-50 dark:bg-black">
                {/* Header */}
                <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
                    <div className="space-y-1">
                        <h1 className="text-2xl font-bold">Template</h1>
                        <p className="text-gray-500">Make sure to stay engaged with your social media platforms!</p>
                    </div>
                </div>

                <Tabs value={activeTab} onValueChange={setActiveTab} className="w-full">
                    <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
                        <TabsList className="bg-white dark:bg-zinc-900 dark:text-white p-1 rounded-lg shadow-sm">
                            <TabsTrigger
                                value="post-template"
                                className="data-[state=active]:bg-gradient-to-r data-[state=active]:from-primary data-[state=active]:to-secondary data-[state=active]:text-white px-4 py-2 rounded-md font-medium transition-all"
                            >
                                Post Template
                            </TabsTrigger>
                            <TabsTrigger
                                value="ai-template"
                                className="data-[state=active]:bg-gradient-to-r data-[state=active]:from-primary data-[state=active]:to-secondary data-[state=active]:text-white px-4 py-2 rounded-md font-medium transition-all"
                            >
                                AI Template
                            </TabsTrigger>
                        </TabsList>

                        <div className="flex items-center gap-3 flex-wrap">
                            <div className="flex border border-gray-300 dark:border-gray-600 rounded-lg overflow-hiddeng">
                                <Button
                                    variant="ghost"
                                    size="sm"
                                    onClick={() => setViewMode("grid")}
                                    className={`h-9 px-3 rounded-none ${viewMode === "grid" ? "bg-gray-200 dark:bg-gray-600 " : "hover:bg-gray-100 dark:hover:bg-gray-800"
                                        }`}
                                >
                                    <Grid3X3 className="h-4 w-4 dark:text-white" />
                                </Button>
                                <Button
                                    variant="ghost"
                                    size="sm"
                                    onClick={() => setViewMode("list")}
                                    className={`h-9 px-3 rounded-none ${viewMode === "list" ? "bg-gray-200 dark:bg-gray-600 dark:text-white" : "hover:bg-gray-100 dark:hover:bg-gray-800"
                                        }`}
                                >
                                    <List className="h-4 w-4 dark:text-white" />
                                </Button>
                            </div>

                            <div className="relative">
                                <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 h-4 w-4 text-gray-400 " />
                                <Input
                                    placeholder="Search"
                                    value={searchQuery}
                                    onChange={(e) => handleSearch(e)}
                                    className="pl-10 w-64 bg-white dark:bg-zinc-900 dark:text-white"
                                />
                            </div>

                            <DropdownMenu>
                                <DropdownMenuTrigger asChild>
                                    <Button variant="outline" className="min-w-[140px] justify-between bg-white dark:bg-zinc-900 dark:text-white">
                                        {platforms.find(p => p.slug === selectedPlatform)?.name || selectedPlatform}
                                        <ChevronDown className="h-4 w-4" />
                                    </Button>
                                </DropdownMenuTrigger>
                                <DropdownMenuContent align="end" className="w-[140px] bg-white dark:bg-zinc-900 dark:text-white">
                                    {platforms.map((platform) => (
                                        <DropdownMenuItem
                                            key={platform.slug}
                                            onClick={() => handlePlatformChnage(platform)}
                                            className={selectedPlatform === platform.slug ? "bg-gray-100 dark:bg-gray-600 dark:text-white" : ""}
                                        >
                                            {platform.name}
                                        </DropdownMenuItem>
                                    ))}
                                </DropdownMenuContent>
                            </DropdownMenu>
                        </div>
                    </div>

                    <TabsContent value="post-template" className="mt-0">
                        {filteredTemplates.length === 0 ? (
                            <div className="flex flex-col items-center justify-center py-20 px-4 bg-white dark:bg-zinc-900 rounded-xl">
                                <div className="relative mb-8">
                                    <div className="w-32 h-32 bg-gradient-to-br from-primary/10 to-secondary/10 dark:from-primary/20 dark:to-secondary/20 rounded-full flex items-center justify-center mb-4">
                                        <div className="w-20 h-20 bg-gradient-to-br from-primary to-secondary rounded-2xl flex items-center justify-center transform rotate-3 shadow-lg">
                                            <FileText className="w-10 h-10 text-white" />
                                        </div>
                                    </div>
                                    <div className="absolute -top-2 -right-2">
                                        <div className="w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center animate-bounce">
                                            <Plus className="w-5 h-5 text-white" />
                                        </div>
                                    </div>
                                </div>

                                <h3 className="text-2xl font-bold text-gray-900 dark:text-gray-100 mb-3">
                                    {t("No post templates yet")}
                                </h3>
                                <p className="text-gray-500 dark:text-gray-400 text-center max-w-md mb-8">
                                    {t("Create your first post template to streamline your social media content creation and maintain consistency across platforms.")}
                                </p>

                            </div>
                        ) : viewMode === "grid" ? (
                            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                                {filteredTemplates.map((template) => (
                                    <div
                                        key={template.id}
                                        className="bg-white dark:bg-zinc-900 rounded-lg border border-gray-200 dark:border-zinc-800 p-4 hover:shadow-md transition-shadow relative group"
                                    >
                                        <div className="absolute top-3 right-3 opacity-0 group-hover:opacity-100 transition-opacity">
                                            <DropdownMenu>
                                                <DropdownMenuTrigger asChild>
                                                    <Button variant="ghost" size="sm" className="h-8 w-8 p-0 bg-black/20 hover:bg-black/30">
                                                        <MoreVertical className="h-4 w-4 text-white" />
                                                    </Button>
                                                </DropdownMenuTrigger>
                                                <DropdownMenuContent align="end">
                                                    <DropdownMenuItem onClick={() => handleTemplateAction("edit", template)}>
                                                        <Edit className="mr-2 h-4 w-4" />
                                                        Edit
                                                    </DropdownMenuItem>

                                                    <DropdownMenuItem
                                                        onClick={() => handleTemplateAction("delete", template)}
                                                        className="text-red-600"
                                                    >
                                                        <Trash2 className="mr-2 h-4 w-4" />
                                                        Delete
                                                    </DropdownMenuItem>
                                                </DropdownMenuContent>
                                            </DropdownMenu>
                                        </div>

                                        <h3 className="font-semibold text-base mb-1 dark:text-white line-clamp-2">
                                            {template.title}
                                        </h3>

                                        {/* Description */}
                                        <p className="text-gray-600 dark:text-gray-400 text-sm line-clamp-3">
                                            {template.description}
                                        </p>

                                        {/* Content */}
                                        <p className="text-gray-600 dark:text-gray-400 text-sm line-clamp-3">
                                            {template.content}
                                        </p>

                                        {/* Media Preview */}
                                        {template.images && template.images.length > 0 && (
                                            <div className="mt-2 flex">
                                                {template.images.slice(0, 2).map((item) =>
                                                    item.isVideo ? (
                                                        <video
                                                            key={item.id}
                                                            src={item.thumbnail}
                                                            muted
                                                            playsInline
                                                            loop
                                                            autoPlay
                                                            className="w-36 h-16 object-cover rounded-lg border border-white dark:border-gray-900"
                                                        />
                                                    ) : (
                                                        <img
                                                            key={item.id}
                                                            src={item.thumbnail || "/placeholder.svg"}
                                                            alt={item.alt || template.title}
                                                            className="w-36 h-16 object-cover rounded-lg border border-white dark:border-gray-900"
                                                        />
                                                    )
                                                )}

                                                {template.images.length > 2 && (
                                                    <div className="w-20 h-16 flex items-center justify-center bg-gray-200 dark:bg-gray-700 rounded-lg border border-white dark:border-gray-900 text-xs font-semibold text-gray-700 dark:text-gray-200">
                                                        +{template.images.length - 2}
                                                    </div>
                                                )}
                                            </div>
                                        )}


                                        {/* Platform */}
                                        <div className="mt-2 text-xs text-gray-500">
                                            {template.platform?.name || template.platform?.slug || "N/A"}
                                        </div>

                                    </div>
                                ))}
                            </div>
                        ) : (
                            <div className="space-y-3">
                                {filteredTemplates.map((template) => (
                                    <div
                                        key={template.id}
                                        onClick={() => handleTemplateSelect(template)}
                                        className={`bg-white dark:bg-zinc-900 rounded-lg border-2 p-4 cursor-pointer hover:shadow-md transition-all ${selectedTemplate?.id === template.id
                                            ? "border-primary shadow-md"
                                            : "border-gray-200 dark:border-zinc-800"
                                            }`}
                                    >
                                        <div className="flex items-start justify-between">
                                            <div className="flex-1">
                                                <h3 className="font-semibold text-lg mb-2 dark:text-white">{template.title}</h3>
                                                <p className="text-gray-600 dark:text-gray-400 text-sm">{template.description}</p>
                                            </div>
                                            <div className="ml-4">
                                                <DropdownMenu>
                                                    <DropdownMenuTrigger asChild>
                                                        <Button variant="ghost" size="sm" className="h-8 w-8 p-0 hover:bg-gray-100">
                                                            <MoreVertical className="h-4 w-4 text-gray-600" />
                                                        </Button>
                                                    </DropdownMenuTrigger>
                                                    <DropdownMenuContent align="end">
                                                        <DropdownMenuItem onClick={() => handleTemplateAction("edit", template)}>
                                                            <Edit className="mr-2 h-4 w-4" />
                                                            Edit
                                                        </DropdownMenuItem>

                                                        <DropdownMenuItem
                                                            onClick={() => handleTemplateAction("delete", template)}
                                                            className="text-red-600"
                                                        >
                                                            <Trash2 className="mr-2 h-4 w-4" />
                                                            Delete
                                                        </DropdownMenuItem>
                                                    </DropdownMenuContent>
                                                </DropdownMenu>
                                            </div>
                                        </div>
                                    </div>
                                ))}
                            </div>
                        )}


                        <Pagination
                            links={post_templates.links}
                            currentPage={post_templates.current_page}
                            lastPage={post_templates.last_page}
                            only={['post_templates']}
                            className="mt-4"
                        />
                    </TabsContent>

                    <TabsContent value="ai-template" className="mt-0">
                        {filteredTemplates.length === 0 ? (
                            <div className="flex flex-col items-center justify-center py-20 px-4 bg-white dark:bg-zinc-900 rounded-xl">
                                <div className="relative mb-8">
                                    <div className="w-32 h-32 bg-gradient-to-br from-secondary/10 to-primary/10 dark:from-secondary/20 dark:to-primary/20 rounded-full flex items-center justify-center mb-4">
                                        <div className="w-20 h-20 bg-gradient-to-br from-secondary to-primary rounded-2xl flex items-center justify-center transform -rotate-3 shadow-lg">
                                            <Sparkles className="w-10 h-10 text-white" />
                                        </div>
                                    </div>
                                    <div className="absolute -top-2 -right-2">
                                        <div className="w-8 h-8 bg-gradient-to-br from-yellow-400 to-orange-400 rounded-full flex items-center justify-center animate-pulse">
                                            <Rocket className="w-4 h-4 text-white" />
                                        </div>
                                    </div>
                                </div>

                                <h3 className="text-2xl font-bold text-gray-900 dark:text-gray-100 mb-3">
                                    {t("No AI templates yet")}
                                </h3>
                                <p className="text-gray-500 dark:text-gray-400 text-center max-w-md mb-8">
                                    {t("Create AI-powered templates to generate compelling content ideas and captions tailored to your brand voice and audience.")}
                                </p>

                            </div>
                        ) : viewMode === "grid" ? (
                            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                                {filteredTemplates.map((template) => (
                                    <div
                                        key={template.id}
                                        className="bg-white dark:bg-zinc-900 rounded-lg border border-gray-200 dark:border-zinc-800 p-4 hover:shadow-md transition-shadow relative group"
                                    >
                                        <div className="absolute top-3 right-3 opacity-0 group-hover:opacity-100 transition-opacity">
                                            <DropdownMenu>
                                                <DropdownMenuTrigger asChild>
                                                    <Button variant="ghost" size="sm" className="h-8 w-8 p-0 bg-black/20 hover:bg-black/30">
                                                        <MoreVertical className="h-4 w-4 text-white" />
                                                    </Button>
                                                </DropdownMenuTrigger>
                                                <DropdownMenuContent align="end">
                                                    <DropdownMenuItem onClick={() => handleAiTemplateAction("edit", template)}>
                                                        <Edit className="mr-2 h-4 w-4" />
                                                        Edit
                                                    </DropdownMenuItem>

                                                    <DropdownMenuItem
                                                        onClick={() => handleAiTemplateAction("delete", template)}
                                                        className="text-red-600"
                                                    >
                                                        <Trash2 className="mr-2 h-4 w-4" />
                                                        Delete
                                                    </DropdownMenuItem>
                                                </DropdownMenuContent>
                                            </DropdownMenu>
                                        </div>

                                        <h3 className="font-semibold text-lg mb-2 dark:text-white">{template.name}</h3>
                                        <p className="text-gray-600 dark:text-gray-400 text-sm line-clamp-3">{template.prompt}</p>
                                        <div className="mt-3 flex items-center justify-between">

                                            <span className="text-xs text-gray-500">{template.platform?.name}</span>
                                        </div>
                                    </div>
                                ))}
                            </div>
                        ) : (
                            <div className="space-y-3">
                                {filteredTemplates.map((template) => (
                                    <div
                                        key={template.id}
                                        onClick={() => handleTemplateSelect(template)}
                                        className={`bg-white dark:bg-zinc-900 rounded-lg border-2 p-4 cursor-pointer hover:shadow-md transition-all ${selectedTemplate?.id === template.id
                                            ? "border-primary shadow-md"
                                            : "border-gray-200 dark:border-zinc-800"
                                            }`}
                                    >
                                        <div className="flex items-start justify-between">
                                            <div className="flex-1">
                                                <h3 className="font-semibold text-lg mb-2 dark:text-white">{template.name}</h3>
                                                <p className="text-gray-600 dark:text-gray-400 text-sm">{template.prompt}</p>
                                            </div>
                                            <div className="ml-4">
                                                <DropdownMenu>
                                                    <DropdownMenuTrigger asChild>
                                                        <Button variant="ghost" size="sm" className="h-8 w-8 p-0 hover:bg-gray-100">
                                                            <MoreVertical className="h-4 w-4 text-gray-600" />
                                                        </Button>
                                                    </DropdownMenuTrigger>
                                                    <DropdownMenuContent align="end">
                                                        <DropdownMenuItem onClick={() => handleAiTemplateAction("edit", template)}>
                                                            <Edit className="mr-2 h-4 w-4" />
                                                            Edit
                                                        </DropdownMenuItem>

                                                        <DropdownMenuItem
                                                            onClick={() => handleAiTemplateAction("delete", template)}
                                                            className="text-red-600"
                                                        >
                                                            <Trash2 className="mr-2 h-4 w-4" />
                                                            Delete
                                                        </DropdownMenuItem>
                                                    </DropdownMenuContent>
                                                </DropdownMenu>
                                            </div>
                                        </div>
                                    </div>
                                ))}
                            </div>
                        )}

                        <Pagination
                            links={ai_templates.links}
                            currentPage={ai_templates.current_page}
                            lastPage={ai_templates.last_page}
                            only={['ai_templates']}
                            className="mt-4"
                        />
                    </TabsContent>
                </Tabs>

                {/* Save Template Modal */}
                <Modal
                    isOpen={saveTemplateModalOpen}
                    onClose={() => {
                        setSaveTemplateModalOpen(false)
                        setTemplateName("")
                        setTemplatePrompt("")
                        setSaveAsTemplate(false)
                    }}
                    title={t("Save Ai Template")}
                    onSubmit={handleSaveTemplate}
                    submitText={t("Save Template")}
                    showSubmit={true}
                    isDataSubmitting={isSubmitting}

                >
                    <div className="space-y-4">
                        <div>
                            <label className="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                {t("Template Name")}
                            </label>
                            <input
                                type="text"
                                value={templateName}
                                onChange={(e) => setTemplateName(e.target.value)}
                                placeholder={t("Enter template name")}
                                className="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-zinc-800 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                            />
                        </div>

                        <div>
                            <label className="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                {t("Prompt")}
                            </label>
                            <textarea
                                value={templatePrompt}
                                onChange={(e) => setTemplatePrompt(e.target.value)}
                                placeholder={t("Describe what this template is for")}
                                rows={3}
                                className="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-zinc-800 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-cyan-500 focus:border-transparent resize-none"
                            />
                        </div>

                        {/* Platform select */}
                        <div>
                            <label className="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Select Platform
                            </label>
                            <Select
                                value={intendedPlatform}
                                onValueChange={(value) => setIntendedPlatform(value)}
                            >
                                <SelectTrigger className="w-full min-w-[180px] bg-gray-50 border-gray-200 dark:bg-zinc-800 dark:border-none dark:text-neutral-200">
                                    <SelectValue placeholder="Choose a platform" />
                                </SelectTrigger>
                                <SelectContent>
                                    {platforms.map((platform) => (
                                        <SelectItem key={platform.id} value={platform.id}>
                                            {platform.name}
                                        </SelectItem>
                                    ))}

                                </SelectContent>
                            </Select>
                        </div>
                    </div>
                </Modal>


                {/* Delete Template Modal */}
                <DeleteModal
                    isOpen={isDeleteTemplateModalOpen}
                    onClose={() => setIsDeleteTemplateModalOpen(false)}
                    title="Delete this Template?"
                    description="Are you really sure you want to delete this social Template?"
                    onConfirm={() => handleTemplateDelete(templateToDelete?.id)}
                    isDeleting={isTemplateDeleting}
                />

                {/* Delete Ai Template Modal */}
                <DeleteModal
                    isOpen={isDeleteAiTemplateModalOpen}
                    onClose={() => setIsDeleteAiTemplateModalOpen(false)}
                    title="Delete this AI Template?"
                    description="Are you really sure you want to delete this Ai Template?"
                    onConfirm={() => handleAiTemplateDelete(aiTemplateToDelete?.id)}
                    isDeleting={isAiTemplateDeleting}
                />
            </div>
        </AppLayout>
    )
}

