// "use client"

// import { useEffect } from "react"
// import { Button } from "@/Components/UI/Button"
// import { X } from "lucide-react"

// const Modal = ({
//   isOpen,
//   onClose,
//   title,
//   children,
//   onSubmit,
//   submitText = "Submit",
//   showSubmit = true,
//   width = "w-full max-w-md",
//   maxWidth = "max-w-md",
//   maxHeight = "max-h-[90vh]",
//   buttonWidth = "w-full",
//   isDataSubmitting = false,
//   size = "md"
// }) => {
//   useEffect(() => {
//     const handleEsc = (event) => {
//       if (event.key === "Escape") onClose()
//     }
//     if (isOpen) {
//       document.addEventListener("keydown", handleEsc)
//       document.body.style.overflow = 'hidden'
//     }
//     return () => {
//       document.removeEventListener("keydown", handleEsc)
//       document.body.style.overflow = 'unset'
//     }
//   }, [isOpen, onClose])

//   if (!isOpen) return null

//   const sizeClasses = {
//     xs: "max-w-xs",
//     sm: "max-w-sm",
//     md: "max-w-md",
//     lg: "max-w-lg",
//     xl: "max-w-xl",
//     "2xl": "max-w-2xl",
//     "3xl": "max-w-3xl",
//     "4xl": "max-w-4xl",
//     "5xl": "max-w-5xl",
//     "6xl": "max-w-6xl",
//     "7xl": "max-w-7xl",
//     full: "max-w-full"
//   }

//   const modalWidth = width.includes('max-w-') ? width : `w-full ${sizeClasses[size] || sizeClasses.md}`

//   return (
//     <div
//       className="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-50 p-4"
//       role="dialog"
//       aria-labelledby="modal-title"
//       onClick={(e) => e.target === e.currentTarget && onClose()}
//     >
//       <div className={`bg-white dark:bg-zinc-900 rounded-xl shadow-2xl ${modalWidth} ${maxHeight} flex flex-col mx-auto overflow-hidden border border-gray-200 dark:border-zinc-800`}>

//         <div className="flex items-center justify-between px-6 py-3 border-b border-gray-200 dark:border-zinc-800 bg-white dark:bg-zinc-900 flex-shrink-0">
//           <h3 id="modal-title" className="text-xl font-semibold text-gray-900 dark:text-gray-100 truncate pr-4">
//             {title}
//           </h3>
//           <button
//             onClick={onClose}
//             className="p-2 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 rounded-lg hover:bg-gray-100 dark:hover:bg-zinc-800 transition-colors flex-shrink-0"
//             aria-label="Close modal"
//           >
//             <X className="w-5 h-5"/>
//           </button>
//         </div>

//         <div className="flex-1 overflow-y-auto p-6">
//           <div className="space-y-4">
//             {children}
//           </div>
//         </div>

//         {showSubmit && (
//           <div className="border-t border-gray-200 dark:border-zinc-800 px-6 py-3 bg-gray-50 dark:bg-zinc-800/50 flex-shrink-0">
//             <div className="flex items-center justify-end gap-3">
//               <Button
//                 variant="outline"
//                 onClick={onClose}
//                 disabled={isDataSubmitting}
//                 className="px-6 py-2"
//               >
//                 Cancel
//               </Button>
//               <Button
//                 isLoading={isDataSubmitting}
//                 variant="default"
//                 className={`${buttonWidth.includes('w-full') ? 'flex-1' : buttonWidth} px-6 py-2`}
//                 onClick={onSubmit}
//               >
//                 {isDataSubmitting ? `${submitText}ing...` : submitText}
//               </Button>
//             </div>
//           </div>
//         )}
//       </div>
//     </div>
//   )
// }

// export { Modal }

"use client";

import { useEffect } from "react";
import { createPortal } from "react-dom";
import { Button } from "@/Components/UI/Button";
import { X } from "lucide-react";

const Modal = ({
  isOpen,
  onClose,
  title,
  children,
  onSubmit,
  submitText = "Submit",
  showSubmit = true,
  width = "w-full max-w-md",
  maxWidth = "max-w-md",
  maxHeight = "max-h-[90vh]",
  buttonWidth = "w-full",
  isDataSubmitting = false,
  size = "md",
  usePortal = true, 
}) => {
  useEffect(() => {
    const handleEsc = (event) => {
      if (event.key === "Escape") onClose();
    };
    if (isOpen) {
      document.addEventListener("keydown", handleEsc);
      document.body.style.overflow = "hidden";
    }
    return () => {
      document.removeEventListener("keydown", handleEsc);
      document.body.style.overflow = "unset";
    };
  }, [isOpen, onClose]);

  if (!isOpen) return null;

  const sizeClasses = {
    xs: "max-w-xs",
    sm: "max-w-sm",
    md: "max-w-md",
    lg: "max-w-lg",
    xl: "max-w-xl",
    "2xl": "max-w-2xl",
    "3xl": "max-w-3xl",
    "4xl": "max-w-4xl",
    "5xl": "max-w-5xl",
    "6xl": "max-w-6xl",
    "7xl": "max-w-7xl",
    full: "max-w-full",
  };

  const modalWidth = width.includes("max-w-") ? width : `w-full ${sizeClasses[size] || sizeClasses.md}`;

  const modalContent = (
    <div
      className="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-[1000] p-4"
      role="dialog"
      aria-labelledby="modal-title"
      onClick={(e) => e.target === e.currentTarget && onClose()}
    >
      <div
        className={`bg-white dark:bg-zinc-900 rounded-xl shadow-2xl ${modalWidth} ${maxHeight} flex flex-col mx-auto overflow-hidden border border-gray-200 dark:border-zinc-800`}
      >
        {/* Header */}
        <div className="flex items-center justify-between px-6 py-3 border-b border-gray-200 dark:border-zinc-800 bg-white dark:bg-zinc-900 flex-shrink-0">
          <h3 id="modal-title" className="text-xl font-semibold text-gray-900 dark:text-gray-100 truncate pr-4">
            {title}
          </h3>
          <button
            onClick={onClose}
            className="p-2 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 rounded-lg hover:bg-gray-100 dark:hover:bg-zinc-800 transition-colors flex-shrink-0"
            aria-label="Close modal"
          >
            <X className="w-5 h-5" />
          </button>
        </div>

        {/* Content */}
        <div className="flex-1 overflow-y-auto p-6">
          <div className="space-y-4">{children}</div>
        </div>

        {/* Footer */}
        {showSubmit && (
          <div className="border-t border-gray-200 dark:border-zinc-800 px-6 py-3 bg-gray-50 dark:bg-zinc-800/50 flex-shrink-0">
            <div className="flex items-center justify-end gap-3">
              <Button
                variant="outline"
                onClick={onClose}
                disabled={isDataSubmitting}
                className="px-6 py-2"
              >
                Cancel
              </Button>
              <Button
                isLoading={isDataSubmitting}
                variant="default"
                className={`${buttonWidth.includes("w-full") ? "flex-1" : buttonWidth} px-6 py-2`}
                onClick={onSubmit}
              >
                {isDataSubmitting ? `${submitText}ing...` : submitText}
              </Button>
            </div>
          </div>
        )}
      </div>
    </div>
  );

  return usePortal ? createPortal(modalContent, document.body) : modalContent;
};

export { Modal };