"use client"

import { cn } from "@/Lib/utils"
import useTranslate from "@/hooks/useTranslate";

export default function StorageSettingsTabs({ activeTab, onTabChange }) {
  const tabs = [
    { id: "local", label: "Local" },
    { id: "aws-s3", label: "AWS S3" },
    { id: "ftp", label: "FTP" },
  ]

  return (
    <div className="px-6 pt-6 pb-4">
      <div className="flex space-x-8 border-b border-gray-200">
        {tabs.map((tab) => (
          <button
            key={tab.id}
            onClick={() => onTabChange(tab.id)}
            className={cn(
              "pb-4 px-1 text-sm font-medium border-b-2 transition-colors",
              activeTab === tab.id
                ? "border-cyan-400 text-cyan-600"
                : "border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300",
            )}
          >
            {tab.label}
          </button>
        ))}
      </div>
    </div>
  )
}
