"use client"

import { useState } from "react"
import { Input } from "@/Components/UI/Input"
import { Button } from "@/Components/UI/Button"
import useTranslate from "@/hooks/useTranslate";
import { router, usePage } from "@inertiajs/react"


const Ftp = () => {
  const { props } = usePage();
  const site_settings = props?.site_settings
  const [isSubmitting, setIsSubmitting] = useState(false)
  const t = useTranslate()

  const [ftpData, setFtpData] = useState({
    enabled: true,
    host: "",
    port: "",
    username: "",
    password: "",
    root: "",
  })



  const handleInputChange = (field, value) => {
    setFtpData((prev) => ({
      ...prev,
      [field]: value,
    }))
  }

  const handleToggle = () => {
    setFtpData((prev) => ({
      ...prev,
      enabled: !prev.enabled,
    }))
  }

  const handleSubmit = (e) => {
    e.preventDefault()
  }

  return (
    <div className="space-y-8">
      {/* Note Section */}
      <div className="bg-blue-50 border border-blue-200 rounded-lg p-4">
        <div className="text-primary font-medium mb-2">Note:</div>
        <div className="text-gray-600 text-sm">
          To utilize FTP storage, kindly enable the FTP extension. This action is imperative for seamless functionality.
          Your cooperation in this matter is greatly appreciated
        </div>
      </div>

      {/* FTP Storage Toggle */}
      <div className="flex items-center space-x-3">
        <span className="text-sm font-medium text-gray-700">FTP Storage</span>
        <button
          onClick={handleToggle}
          className={`relative inline-flex h-6 w-11 items-center rounded-full transition-colors focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:ring-offset-2 ${
            ftpData.enabled ? "bg-cyan-500" : "bg-gray-200"
          }`}
        >
          <span
            className={`inline-block h-4 w-4 transform rounded-full bg-white transition-transform ${
              ftpData.enabled ? "translate-x-6" : "translate-x-1"
            }`}
          />
        </button>
      </div>

      {/* Form Fields */}
      <form onSubmit={handleSubmit} className="space-y-6">
        {/* Host and Port Row */}
        <div className="grid lg:grid-cols-2 grid-cols-1 lg:gap-6 gap-4">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">Host</label>
            <Input
              type="text"
              placeholder="Enter FTP host (e.g., ftp.example.com)"
              value={ftpData.host}
              onChange={(e) => handleInputChange("host", e.target.value)}
              className="bg-gray-50 border-gray-200"
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">Port</label>
            <Input
              type="text"
              placeholder="Enter FTP port (default: 21)"
              value={ftpData.port}
              onChange={(e) => handleInputChange("port", e.target.value)}
              className="bg-gray-50 border-gray-200"
            />
          </div>
        </div>

        {/* Username, Password, and Root Row */}
        <div className="grid grid-cols-3 gap-6">
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">User Name</label>
            <Input
              type="text"
              placeholder="Enter FTP username"
              value={ftpData.username}
              onChange={(e) => handleInputChange("username", e.target.value)}
              className="bg-gray-50 border-gray-200"
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">Password</label>
            <Input
              type="password"
              placeholder="Enter FTP password"
              value={ftpData.password}
              onChange={(e) => handleInputChange("password", e.target.value)}
              className="bg-gray-50 border-gray-200"
            />
          </div>
          <div>
            <label className="block text-sm font-medium text-gray-700 mb-2">Root</label>
            <Input
              type="text"
              placeholder="Enter root directory path"
              value={ftpData.root}
              onChange={(e) => handleInputChange("root", e.target.value)}
              className="bg-gray-50 border-gray-200"
            />
          </div>
        </div>

        {/* Submit Button */}
        <Button type="submit" className="bg-cyan-400 hover:bg-cyan-500 text-white px-8 py-2.5 rounded-md font-medium">
          Submit
        </Button>
      </form>
    </div>
  )
}

export default Ftp
