import { Avatar, AvatarFallback, AvatarImage } from "@/Components/UI/Avatar"

export default function AccountAvatars({ accounts, size = "md" }) {
  const sizeClasses = {
    sm: "w-7 h-7",
    md: "w-8 h-8",
  }

  const avatarSize = sizeClasses[size]

  return (
    <div className="flex -space-x-5 relative">
      {accounts.slice(0, 4).map((account, index) => (
        <Avatar key={account.id} className={`${avatarSize} border-2 border-white`}>
          <AvatarImage src={account.avatar} />
          <AvatarFallback>U{index + 1}</AvatarFallback>
        </Avatar>
      ))}

      {accounts.length > 3 && (
        <div
          className={`${avatarSize} bg-teal-500 rounded-full border-2 border-white flex items-center justify-center z-10`}
        >
          <span className="text-white text-xs font-medium">
            {`${accounts.length - 4}+` }
          </span>
        </div>
      )}
    </div>
  )
}
