"use client"

import { Trash2 } from "lucide-react"
import { Button } from "@/Components/UI/Button"
import { Modal } from "@/Components/UI/Modal"
import useTranslate from "@/hooks/useTranslate";

export default function DeleteModal({
  isOpen,
  onClose,
  title = "Delete this item?",
  description = "Are you really sure you want to delete this item?",
  onConfirm,
  isDeleting = false,
}) {
  const handleConfirm = () => {
    onConfirm()
  }

  return (
    <Modal
      isOpen={isOpen}
      onClose={onClose}
      title={title}
      showSubmit={false}
      size="md"
    >
      <div className="text-center space-y-6">
        {/* Red trash icon */}
        <div className="flex justify-center">
          <div className="w-16 h-16 bg-red-500 rounded-full flex items-center justify-center">
            <Trash2 className="w-8 h-8 text-white" />
          </div>
        </div>

        {/* Description */}
        <p className="text-gray-600 dark:text-gray-400 text-center">
          {description}
        </p>

        {/* Buttons */}
        <div className="flex gap-3 pt-4">
          <Button
            variant="outline"
            onClick={onClose}
            className="flex-1 bg-transparent text-gray-700 dark:text-gray-300 border-gray-300 dark:border-gray-600 hover:bg-gray-100 dark:hover:bg-zinc-800"
            disabled={isDeleting}
          >
            Cancel
          </Button>
          <Button
            onClick={handleConfirm}
            className="flex-1 bg-red-500 hover:bg-red-600 text-white shadow-md hover:shadow-lg transition-all duration-200"
            disabled={isDeleting}
          >
            {isDeleting ? "Deleting..." : "Delete"}
          </Button>
        </div>
      </div>
    </Modal>
  )
}
