import { PieChart, Pie, Cell, ResponsiveContainer, Legend } from "recharts"
import { Download } from "lucide-react"

const StatisticByGender = ({ data = [] }) => {
  const CustomLegend = (props) => {
    const { payload } = props
    return (
      <div className="flex justify-center gap-6 mt-4">
        {payload.map((entry, index) => (
          <div key={index} className="flex items-center gap-2">
            <div className="w-3 h-3 rounded-full" style={{ backgroundColor: entry.color }} />
            <span className="text-sm text-gray-600">{entry.value}</span>
          </div>
        ))}
      </div>
    )
  }

  // Transform data for recharts
  const chartData = data.map((item) => ({
    name: item.gender,
    value: item.percentage,
    color: item.color,
  }))

  return (
    <div className="bg-white dark:bg-zinc-900 rounded-lg border border-gray-200 dark:border-zinc-800 p-6 shadow-sm">
      {/* Header */}
      <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
        <h3 className="text-lg font-semibold text-gray-900">Statistic by Gender</h3>
        <button className="p-2 hover:bg-gray-100 rounded-lg transition-colors">
          <Download className="w-4 h-4 text-gray-500" />
        </button>
      </div>

      {/* Donut Chart */}
      <div className="h-64 mb-4">
        <ResponsiveContainer width="100%" height="100%">
          <PieChart>
            <Pie data={chartData} cx="50%" cy="50%" innerRadius={60} outerRadius={100} paddingAngle={2} dataKey="value">
              {chartData.map((entry, index) => (
                <Cell key={`cell-${index}`} fill={entry.color} />
              ))}
            </Pie>
            <Legend content={<CustomLegend />} />
          </PieChart>
        </ResponsiveContainer>
      </div>
    </div>
  )
}

export default StatisticByGender
