<?php

namespace Database\Seeders\Core;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = json_decode(file_get_contents(resource_path('data/countries.json')), true);

        $insertData = collect($countries)->map(function ($country) {
            return [
                'uid' => $country['uid'] ?? null,
                'name' => $country['name'],
                'code' => $country['code'],
                'phone_code' => $country['phone_code'],
                'flag' => $country['flag'] ?? null,
                'status' => $country['status'] ?? 1,
            ];
        })->toArray();

        DB::table('countries')->insert($insertData);
    }
}
