<?php


use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {

        // Trust proxies for HTTPS detection behind load balancers/CDNs
        $middleware->trustProxies(at: '*');

        $middleware->web(append: [
            \App\Http\Middleware\CleanJsonResponse::class,
            \App\Http\Middleware\CheckInstallation::class,
            \App\Http\Middleware\SoftwareVerification::class,
            \App\Http\Middleware\LicenseGuard::class,
            \App\Http\Middleware\HandleInertiaRequests::class,
            \App\Http\Middleware\SetLocale::class,
            \App\Http\Middleware\Demo::class,
        ]);

        $middleware->alias([
            'redirect.if.installed' => \App\Http\Middleware\RedirectIfInstalled::class,
            'auth' => \App\Http\Middleware\Authenticate::class,
            'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
            'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
            'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
            'sanitizer' => \App\Http\Middleware\Sanitization::class,
            'demo' => \App\Http\Middleware\Demo::class,
            'https' => \App\Http\Middleware\HttpsMiddleware::class,
            'dos.security' => \App\Http\Middleware\SecurityMiddleware::class,
            'maintenance.mode' => \App\Http\Middleware\MaintenanceMode::class,
            'domain.verified' => \App\Http\Middleware\VerifyDomain::class,
            'check.domain' => \App\Http\Middleware\DomainVerificationMiddleware::class,
            'license.guard' => \App\Http\Middleware\LicenseGuard::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })
    ->create();
