<?php

namespace App\Models\Core;

use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class MailGateway extends Model
{
    use HasFactory , Filterable;

    
    protected $guarded = [];

    protected $casts = [
        'credential' => 'object',
    ];

    
    protected static function booted(){

        static::creating(function (Model $model) {
            $model->uid        = Str::uuid();
        });
    }
}
