<?php

namespace App\Models;

use App\Models\Core\File;
use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CampaignPost extends Model
{
    use HasFactory , Filterable;

    protected $fillable = [
        'campaign_id',
        'account_id',
        'platform_id',
        'content',
        'link',
        'is_scheduled',
        'schedule_time',
        'repeat_every',
        'repeat_end_date',
        'is_draft',
        'post_type',
        'status',
        'posted_at',
    ];

    protected $casts = [
        'schedule_time' => 'datetime',
        'repeat_end_date' => 'datetime',
        'posted_at' => 'datetime',
        'is_scheduled' => 'boolean',
        'is_draft' => 'boolean',
    ];

    // Relationships
    public function campaign()
    {
        return $this->belongsTo(Campaign::class);
    }

    public function account()
    {
        return $this->belongsTo(SocialAccount::class);
    }

    public function platform()
    {
        return $this->belongsTo(Platform::class);
    }

    public function files()
    {
        return $this->belongsToMany(File::class, 'campaign_post_files')
            ->withPivot('caption', 'order')
            ->withTimestamps();
    }
}
