<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PostUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id' => ['required' , 'exists:social_posts'],
            'content' => ['nullable', 'string', 'max:5000'],
            'postTypes' => ['required', 'array', 'min:1'],
            'postTypes.*' => ['string', 'in:feed,reels,story,video,carousel'],
            'files' => ['nullable', 'array'],
            'files.*.id' => ['required_with:files', 'integer', 'exists:files,id'],
            'files.*.caption' => ['nullable', 'string', 'max:255'],
            'files.*.alt' => ['nullable', 'string', 'max:255'],
            'files.*.order' => ['nullable', 'integer', 'min:1'],
            'links' => ['nullable', 'array'],
            'is_scheduled' => ['required', 'in:0,1'],
            'scheduled_time' => ['nullable', 'date', 'after_or_equal:now'],
            'is_draft' => ['required', 'in:0,1'],
        ];
    }

    public function messages(): array
    {
        return [
            'content.string' => 'The post content must be text.',
            'content.max' => 'The post content may not exceed 5000 characters.',

            'postTypes.required' => 'At least one post type is required.',
            'postTypes.array' => 'The post types must be in array format.',
            'postTypes.*.string' => 'Each post type must be a valid string.',
            'postTypes.*.in' => 'The selected post type is invalid.',

            'files.array' => 'Files must be sent in an array format.',
            'files.*.id.required_with' => 'Each file must have an ID.',
            'files.*.id.integer' => 'File IDs must be valid numbers.',
            'files.*.id.exists' => 'One of the selected files does not exist.',
            'files.*.caption.string' => 'File caption must be text.',
            'files.*.caption.max' => 'File caption may not exceed 255 characters.',
            'files.*.alt.string' => 'File alt text must be text.',
            'files.*.alt.max' => 'File alt text may not exceed 255 characters.',
            'files.*.order.integer' => 'File order must be a valid number.',
            'files.*.order.min' => 'File order must be at least 1.',

            'links.array' => 'Links must be provided in an array.',

            'is_scheduled.required' => 'Please specify whether the post is scheduled.',
            'is_scheduled.in' => 'Invalid value for scheduled status.',

            'scheduled_time.date' => 'Scheduled time must be a valid date.',
            'scheduled_time.after_or_equal' => 'Scheduled time must be in the future.',

            'is_draft.required' => 'Please specify whether the post is a draft.',
            'is_draft.in' => 'Invalid value for draft status.',
        ];
    }

}
