import { usePage } from "@inertiajs/react";

export default function useTranslate() {
  const { translations , locale } = usePage().props;  

  const slugify = (text) =>
    text.toLowerCase().replace(/[^a-z0-9]+/g, "_").replace(/^_|_$/g, "");

  return function t(text) {
    const key = slugify(text);
    return translations?.[key] ?? text;
  };
}
