import React from 'react';
import { Head } from '@inertiajs/react';
import { Settings2, Clock, AlertCircle } from 'lucide-react';

export default function Maintenance() {
    return (
        <>
            <Head title="Maintenance Mode" />

            <div className="min-h-screen bg-gray-50 dark:bg-gray-900 flex items-center justify-center px-4">
                <div className="max-w-lg w-full">
                    <div className="bg-white dark:bg-zinc-900 rounded-2xl shadow-xl p-8 md:p-12">
                        <div className="flex justify-center mb-6">
                            <div className="relative">
                                <div className="w-24 h-24 bg-orange-100 dark:bg-orange-900/20 rounded-full flex items-center justify-center">
                                    <Settings2 className="w-12 h-12 text-orange-600 dark:text-orange-500 animate-spin-slow" />
                                </div>
                                <div className="absolute -bottom-1 -right-1 w-8 h-8 bg-yellow-100 dark:bg-yellow-900/20 rounded-full flex items-center justify-center">
                                    <Clock className="w-4 h-4 text-yellow-600 dark:text-yellow-500" />
                                </div>
                            </div>
                        </div>

                        <h1 className="lg:text-3xl text-2xl font-bold text-center text-gray-900 dark:text-white mb-4">
                            Under Maintenance
                        </h1>

                        <p className="text-center text-gray-600 dark:text-gray-400 mb-8">
                            We're currently performing scheduled maintenance to improve your experience.
                            The site will be back online shortly.
                        </p>

                        <div className="bg-orange-50 dark:bg-orange-900/10 border border-orange-200 dark:border-orange-800 rounded-lg p-4 mb-6">
                            <div className="flex items-start">
                                <AlertCircle className="w-5 h-5 text-orange-600 dark:text-orange-500 mt-0.5 mr-3 flex-shrink-0" />
                                <div className="text-sm text-orange-800 dark:text-orange-300">
                                    <p className="font-semibold mb-1">What's happening?</p>
                                    <ul className="list-disc list-inside space-y-1 text-orange-700 dark:text-orange-400">
                                        <li>System updates and improvements</li>
                                        <li>Performance optimizations</li>
                                        <li>Security enhancements</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div className="text-center">
                            <p className="text-sm text-gray-500 dark:text-gray-400 mb-4">
                                Expected to be back online soon
                            </p>

                            <button
                                onClick={() => window.location.reload()}
                                className="inline-flex items-center px-6 py-3 bg-gray-900 dark:bg-white text-white dark:text-gray-900 font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-gray-100 transition-colors duration-200"
                            >
                                <svg className="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                </svg>
                                Refresh Page
                            </button>
                        </div>

                        <div className="mt-8 pt-6 border-t border-gray-200 dark:border-zinc-800">
                            <p className="text-xs text-center text-gray-400 dark:text-gray-500">
                                If you have urgent concerns, please contact support
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <style jsx>{`
                @keyframes spin-slow {
                    from {
                        transform: rotate(0deg);
                    }
                    to {
                        transform: rotate(360deg);
                    }
                }

                .animate-spin-slow {
                    animation: spin-slow 8s linear infinite;
                }
            `}</style>
        </>
    );
}