"use client"
import AppLayout from "@/Layouts/AppLayout"
import CampaignWizard from "@/Components/Campaign/CampaignWizard"
import { Sparkles } from "lucide-react"
import { route } from "ziggy-js"

export default function CreateCampaign({platforms, accounts, media , post_templates, ai_modules}) {
  const breadcrumbs = [{ label: "Home", href: route("user.home") }, { label: "Campaign", href: route("user.campaign.index") }, { label: "Create" }]

  return (
    <AppLayout breadcrumbs={breadcrumbs}>
      <div className="flex-1 p-6 overflow-auto bg-gradient-to-br from-gray-50 to-gray-100 dark:from-zinc-950 dark:to-black min-h-screen">
        {/* Header */}
        <div className="mb-6">
          <div className="flex items-center gap-3 mb-2">
            <div>
              <Sparkles className="h-6 w-6 text-primary" />
            </div>
            <h1 className="text-xl sm:text-2xl dark:text-gray-200 font-bold">
              Create New Campaign
            </h1>
          </div>
          <p className="text-gray-500 dark:text-gray-200">
            Plan and organize your social media campaigns with professional precision
          </p>
        </div>

        <CampaignWizard
          platforms={platforms}
          accounts={accounts}
          media={media}
          post_templates={post_templates}
          ai_modules={ai_modules}
        />
      </div>
    </AppLayout>
  )
}
