import React from "react";
import Select from "react-select";

function RSelect({ options, value, onChange, placeholder = "Select...", isMulti = false, maxMenuHeight = 300, className = "", ...props }) {
  return (
    <div className="relative">
      <Select
        options={options}
        isMulti={isMulti}
        value={
          isMulti
            ? options.filter((opt) => value?.includes(opt.value))
            : options.find((opt) => opt.value === value) || null
        }
        onChange={(selected) => {
          if (isMulti) {
            onChange(selected ? selected.map((opt) => opt.value) : []);
          } else {
            onChange(selected ? selected.value : null);
          }
        }}
        placeholder={placeholder}
        isSearchable
        isClearable
        maxMenuHeight={maxMenuHeight}
        menuPosition="fixed"
        menuPlacement="auto"
        menuShouldScrollIntoView={false}
        menuPortalTarget={document.body}
        className={`w-full text-bodyTextSecondary ${className}`}
        styles={{
          menuPortal: (base) => ({
            ...base,
            zIndex: 99999,
            position: 'fixed'
          }),
          menu: (base) => ({
            ...base,
            zIndex: 99999,
            position: 'absolute'
          }),
          control: (base, state) => ({
            ...base,
            minHeight: '42px',
            border: state.isFocused 
              ? '1px solid rgb(59 130 246)' 
              : '1px solid rgb(209 213 219)',
            boxShadow: state.isFocused 
              ? '0 0 0 3px rgba(59, 130, 246, 0.1)' 
              : 'none',
            '&:hover': {
              border: state.isFocused 
                ? '1px solid rgb(59 130 246)' 
                : '1px solid rgb(156 163 175)'
            }
          })
        }}
        classNames={{
          control: ({ isFocused }) =>
            `flex min-h-[42px] rounded-lg shadow-sm text-sm transition bg-white dark:bg-zinc-900`,
          valueContainer: () => "px-3 py-1",
          placeholder: () => "text-gray-500 dark:text-gray-400",
          singleValue: () => "text-gray-900 dark:text-gray-100",
          indicatorsContainer: () => "px-2 gap-1",
          dropdownIndicator: ({ isFocused }) =>
            `transition ${isFocused ? "text-blue-500" : "text-gray-400"} hover:text-blue-500`,
          clearIndicator: () => "text-gray-400 hover:text-red-500 transition cursor-pointer",
          menu: () =>
            "mt-1 rounded-lg shadow-2xl border border-gray-200 dark:border-gray-600 bg-white dark:bg-zinc-900",
          menuList: () => "p-1 max-h-64 overflow-y-auto scrollbar-thin scrollbar-thumb-gray-300 dark:scrollbar-thumb-gray-600 scrollbar-track-transparent",
          option: ({ isFocused, isSelected }) =>
            `px-3 py-2 text-sm cursor-pointer transition-colors rounded-md mx-1 
             ${isSelected 
               ? "bg-blue-500 text-white" 
               : isFocused 
               ? "bg-blue-50 dark:bg-gray-700 text-gray-900 dark:text-gray-100" 
               : "text-gray-900 dark:text-gray-100"
             }`,
          multiValue: () => "bg-blue-100 dark:bg-gray-700 rounded-md flex items-center mx-0.5",
          multiValueLabel: () => "text-blue-800 dark:text-gray-100 text-sm px-1",
          multiValueRemove: () => "text-blue-600 hover:text-red-500 cursor-pointer px-1",
          noOptionsMessage: () => "text-gray-500 dark:text-gray-400 px-3 py-2 text-sm",
          loadingMessage: () => "text-gray-500 dark:text-gray-400 px-3 py-2 text-sm"
        }}
        {...props}
      />
    </div>
  );
}

export { RSelect };
