import { Icon } from "@iconify/react"

const platformIcons = {
  facebook: { icon: "brandico:facebook-rect", size: 32, color: "text-blue-600" },
  instagram: { icon: "skill-icons:instagram", size: 32 },
  twitter: { icon: "fa7-brands:square-x-twitter", size: 32 },
  linkedin: { icon: "devicon:linkedin", size: 32 },
  tiktok: { icon: "logos:tiktok-icon", size: 32 },
  youtube: { icon: "logos:youtube-icon", size: 32 },
  threads: { icon: "fa6-brands:square-threads", size: 32 },
}

export default function PlatformIcon({ slug, size = 32, round = false }) {
  const platform = platformIcons[slug]

  if (!platform) return null

  return (
    <Icon
      icon={platform.icon}
      width={size}
      height={size}
      className={`inline-block ${platform.color} ${round ? "rounded-full" : ""}`}
    />
  )
}
