"use client"

import { MoreHorizontal, MessageCircle, Share2, Edit, Rocket, Eye, Share, Trash2 } from "lucide-react"
import PlatformIcon from "@/Components/UI/PlatformIcon"
import { Avatar, AvatarFallback, AvatarImage } from "@/Components/UI/Avatar"
import FailedReasonTooltip from "@/Components/UI/FailedReasonTooltip"


const PostCardList = ({ post, onMenuAction, openMenus, onToggleMenu }) => {
  const getStatusStyle = (status) => {
    const styles = {
      published: "bg-emerald-50 text-emerald-700 border-emerald-200 dark:bg-emerald-900/20 dark:text-emerald-400 dark:border-emerald-800",
      scheduled: "bg-blue-50 text-blue-700 border-blue-200 dark:bg-blue-900/20 dark:text-blue-400 dark:border-blue-800",
      pending: "bg-amber-50 text-amber-700 border-amber-200 dark:bg-amber-900/20 dark:text-amber-400 dark:border-amber-800",
      draft: "bg-gray-50 text-gray-700 border-gray-200 dark:bg-gray-900/20 dark:text-gray-400 dark:border-gray-700",
      failed: "bg-red-50 text-red-700 border-red-200 dark:bg-red-900/20 dark:text-red-400 dark:border-red-800",
    }
    return styles[status?.toLowerCase()] || styles.draft
  }

  return (
    <div className="group bg-white dark:bg-zinc-900 rounded-xl border border-gray-200 dark:border-zinc-800 shadow-sm hover:shadow-md hover:border-gray-300 dark:hover:border-zinc-600 transition-all duration-200 p-4">
      <div className="flex items-center flex-wrap gap-5">
        {/* Avatar with platform overlay */}
        <div className="relative flex-shrink-0">
          <Avatar className="h-11 w-11 ring-2 ring-gray-100 dark:ring-zinc-700">
            <AvatarImage src={post?.account?.avatar} alt="User Avatar" />
            <AvatarFallback className="text-sm font-medium">{post.author?.charAt(0) || "A"}</AvatarFallback>
          </Avatar>
          <div className="absolute -bottom-1 -right-1 w-5 h-5 rounded-full bg-white dark:bg-zinc-900 flex items-center justify-center ring-2 ring-white dark:ring-zinc-900">
            <PlatformIcon slug={post.platform?.slug} size={14} round={true} />
          </div>
        </div>

        {/* Author and date */}
        <div className="flex-shrink-0 min-w-0 w-32">
          <p className="font-medium text-gray-900 dark:text-white text-sm truncate">{post.author || "Author"}</p>
          <p className="text-xs text-gray-500 dark:text-gray-400">
            {new Date(post.date).toLocaleDateString(undefined, {
              month: 'short',
              day: 'numeric',
              hour: '2-digit',
              minute: '2-digit',
            })}
          </p>
        </div>

        {/* Media thumbnail */}
        {post.media && post.media.length > 0 && (
          <div className="flex-shrink-0">
            <div className="relative">
              {post.media[0].isVideo ? (
                <video
                  src={post.media[0].thumbnail || "/placeholder.mp4"}
                  className="w-20 h-14 rounded-lg object-cover bg-gray-100 dark:bg-zinc-800"
                  muted
                  playsInline
                />
              ) : (
                <img
                  src={post.media[0].url || "/placeholder.svg"}
                  alt={post.media[0].alt || "Post thumbnail"}
                  className="w-20 h-14 rounded-lg object-cover bg-gray-100 dark:bg-zinc-800"
                />
              )}
              {post.media.length > 1 && (
                <div className="absolute -top-1 -right-1 w-5 h-5 bg-gray-900/75 text-white text-xs font-medium rounded-full flex items-center justify-center">
                  {post.media.length}
                </div>
              )}
            </div>
          </div>
        )}

        {/* Content */}
        <div className="flex-1 min-w-0 px-2">
          <p className="text-sm text-gray-900 dark:text-white leading-relaxed line-clamp-2">
            {post.content || "No content available"}
          </p>
        </div>

        {/* Status badge */}
        <div className="flex-shrink-0">
          <span className={`inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium border ${getStatusStyle(post.status)}`}>
            {post.status || "Published"}
            {post.status?.toLowerCase() === 'failed' && (
              <FailedReasonTooltip
                reason={post.failedReason}
                fallbackMessage={post.failedReasonFallback}
              />
            )}
          </span>
        </div>

        {/* Engagement metrics */}
        {post.engagement && (
          <div className="flex items-center gap-4 text-xs text-gray-500 dark:text-gray-400 flex-shrink-0 min-w-0">
            <div className="flex items-center gap-1.5">
              <MessageCircle className="w-3.5 h-3.5" />
              <span className="font-medium">{post.engagement.comments || 0}</span>
            </div>
            <div className="flex items-center gap-1.5">
              <Share2 className="w-3.5 h-3.5" />
              <span className="font-medium">{post.engagement.shares || 0}</span>
            </div>
          </div>
        )}

        {/* Menu */}
        <div className="relative flex-shrink-0">
          <button
            onClick={(e) => onToggleMenu(post.id, e)}
            className="p-1.5 hover:bg-gray-100 dark:hover:bg-zinc-800 rounded-lg transition-colors opacity-0 group-hover:opacity-100"
          >
            <MoreHorizontal className="w-4 h-4 text-gray-500 dark:text-gray-400" />
          </button>

          {openMenus[post.id] && (
            <div
              onClick={(e) => e.stopPropagation()}
              className="absolute right-0 top-full mt-1 bg-white dark:bg-zinc-800 border border-gray-200 dark:border-zinc-800 rounded-lg shadow-xl py-1 z-50 min-w-[140px] ring-1 ring-black/5 dark:ring-white/10"
            >
              <button
                onClick={() => onMenuAction(post.id, "preview")}
                className="w-full px-3 py-2 text-left text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-zinc-700 flex items-center gap-2 transition-colors"
              >
                <Eye className="w-3.5 h-3.5" />
                Preview
              </button>
              <button
                onClick={() => onMenuAction(post.id, "edit")}
                className="w-full px-3 py-2 text-left text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-zinc-700 flex items-center gap-2 transition-colors"
              >
                <Edit className="w-3.5 h-3.5" />
                Edit Post
              </button>
              <button
                onClick={() => onMenuAction(post.id, "publish")}
                className="w-full px-3 py-2 text-left text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-zinc-700 flex items-center gap-2 transition-colors"
              >
                <Rocket className="w-3.5 h-3.5" />
                Publish Now
              </button>
              <div className="border-t border-gray-100 dark:border-zinc-600 my-1"></div>
              <button
                onClick={() => onMenuAction(post.id, "delete")}
                className="w-full px-3 py-2 text-left text-sm text-red-600 hover:bg-red-50 dark:hover:bg-red-900/20 flex items-center gap-2 transition-colors"
              >
                <Trash2 className="w-3.5 h-3.5" />
                Delete
              </button>
            </div>
          )}
        </div>
      </div>
    </div>
  )
}

export default PostCardList
