<?php

namespace Database\Seeders;

use App\Enums\StatusEnum;
use App\Models\PostTemplate;
use App\Models\User;
use App\Models\Platform;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Faker\Factory as Faker;

class DemoTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds for templates.
     */
    public function run(): void
    {
        $faker = Faker::create();

        $users = User::all();
        $platforms = Platform::all();

        if ($users->isEmpty() || $platforms->isEmpty()) {
            $this->command->warn('Please run DemoUserSeeder and PlatformSeeder first!');
            return;
        }

        // Create user-specific post templates
        $this->createPostTemplates($users, $platforms, $faker);
    }


    /**
     * Create user-specific post templates
     */
    private function createPostTemplates($users, $platforms, $faker): void
    {
        $postTemplateData = [
            'Quick Announcement' => 'Quick update: {ANNOUNCEMENT}. More details coming soon! {HASHTAGS}',
            'Question for Engagement' => 'Quick question for our community: {QUESTION}? \n\nA) {OPTION_A}\nB) {OPTION_B}\n\nVote in comments! 👇',
            'Link Share' => 'Check this out: {LINK_DESCRIPTION}\n\n🔗 {LINK_URL}\n\n{HASHTAGS}',
            'Photo Caption' => '{PHOTO_DESCRIPTION}\n\n📸 {PHOTO_CONTEXT}\n\n{HASHTAGS}',
            'Weekend Vibes' => '🌟 Weekend vibes: {WEEKEND_ACTIVITY}\n\nHow are you spending your weekend? 💬\n\n{HASHTAGS}',
        ];

        $templateCounter = 0;

        foreach ($users as $user) {
            $numTemplates = rand(3, 7);
            $userPlatforms = $platforms->random($numTemplates);

            foreach ($userPlatforms as $i => $platform) {
                $templateName = array_keys($postTemplateData)[$i % count($postTemplateData)];
                $templateContent = $postTemplateData[$templateName];
                $templateCounter++;

                PostTemplate::create([
                    'uid' => Str::uuid(),
                    'user_id' => $user->id,
                    'platform_id' => $platform->id,
                    'title' => $templateName . ' - ' . $user->name,
                    'description' => 'Personal template for ' . strtolower($templateName),
                    'content' => $templateContent,
                    'link' => $faker->boolean(30) ? $faker->url : null,
                    'created_at' => $faker->dateTimeBetween('-3 months', 'now'),
                    'updated_at' => now(),
                ]);
            }
        }

        $this->command->info("Created {$templateCounter} user post templates!");
    }

}