"use client"

import { AlertCircle } from "lucide-react"
import { Tooltip, TooltipContent, TooltipProvider, TooltipTrigger } from "@/Components/UI/Tooltip"

const FailedReasonTooltip = ({ reason, fallbackMessage = "Reason unknown" }) => {
  const displayReason = reason || fallbackMessage

  return (
    <TooltipProvider delayDuration={200}>
      <Tooltip>
        <TooltipTrigger asChild>
          <button
            type="button"
            className="inline-flex items-center justify-center p-0.5 ml-1 text-red-600 dark:text-red-400 hover:text-red-700 dark:hover:text-red-300 transition-colors"
          >
            <AlertCircle className="w-3.5 h-3.5" />
          </button>
        </TooltipTrigger>
        <TooltipContent
          side="top"
          className="max-w-xs bg-white dark:bg-zinc-900 text-red-600 dark:text-red-400 border-2 border-red-500 dark:border-red-600 shadow-lg"
        >
          <div className="flex items-start gap-2">
            <AlertCircle className="w-3.5 h-3.5 flex-shrink-0 mt-0.5" />
            <p className="text-xs leading-relaxed break-words">{displayReason}</p>
          </div>
        </TooltipContent>
      </Tooltip>
    </TooltipProvider>
  )
}

export default FailedReasonTooltip
