"use client"

import { CheckCircle, Calendar, Users, FileText, Sparkles } from "lucide-react"
import { formatDate } from '@/Lib';
import useTranslate from "@/hooks/useTranslate";
import AccountAvatars from "@/Components/Platform/AccountAvatars"

const StepThree = ({ formData }) => {
  const t = useTranslate()

  return (
    <div className="space-y-8">
      {/* Header */}
      <div className="text-center">
        <div className="mx-auto w-16 h-16 bg-gradient-to-r from-primary to-secondary rounded-full flex items-center justify-center mb-4">
          <Sparkles className="w-8 h-8 text-white" />
        </div>
        <h2 className="text-2xl font-bold text-gray-900 dark:text-white mb-2">
          Review & Launch
        </h2>
        <p className="text-gray-600 dark:text-gray-400">
          Review your campaign details before launching
        </p>
      </div>

      {/* Campaign Summary */}
      <div className="max-w-2xl mx-auto space-y-6">
        {/* Campaign Name */}
        <div className="bg-gradient-to-r from-primary/5 to-secondary/5 dark:from-primary/10 dark:to-secondary/10 rounded-xl p-6 border border-primary/10">
          <div className="flex items-center gap-4">
            <div className="w-12 h-12 bg-gradient-to-r from-primary to-secondary rounded-full flex items-center justify-center">
              <FileText className="w-6 h-6 text-white" />
            </div>
            <div>
              <h3 className="text-lg font-semibold text-gray-900 dark:text-white">
                Campaign Details
              </h3>
              <p className="text-gray-600 dark:text-gray-400 font-medium">
                {formData.campaignName || "Untitled Campaign"}
              </p>
              {formData.description && (
                <p className="text-sm text-gray-500 dark:text-gray-400 mt-1">
                  {formData.description}
                </p>
              )}
            </div>
          </div>
        </div>

        {/* Date Range */}
        <div className="bg-white dark:bg-zinc-900 rounded-xl p-6 border border-gray-200 dark:border-zinc-800">
          <div className="flex items-center gap-4">
            <div className="w-12 h-12 bg-gradient-to-r from-primary to-secondary rounded-full flex items-center justify-center">
              <Calendar className="w-6 h-6 text-white" />
            </div>
            <div>
              <h3 className="text-lg font-semibold text-gray-900 dark:text-white">
                Campaign Duration
              </h3>
              <div className="space-y-1">
                <p className="text-gray-600 dark:text-gray-400">
                  <span className="font-medium">Start:</span> {formatDate(formData.startDate) || "Not specified"}
                </p>
                <p className="text-gray-600 dark:text-gray-400">
                  <span className="font-medium">End:</span> {formatDate(formData.endDate) || "Not specified"}
                </p>
              </div>
            </div>
          </div>
        </div>

        {/* Selected Accounts */}
        <div className="bg-white dark:bg-zinc-900 rounded-xl p-6 border border-gray-200 dark:border-zinc-800">
          <div className="flex items-start gap-4">
            <div className="w-12 h-12 bg-gradient-to-r from-primary to-secondary rounded-full flex items-center justify-center">
              <Users className="w-6 h-6 text-white" />
            </div>
            <div className="flex-1">
              <h3 className="text-lg font-semibold text-gray-900 dark:text-white mb-3">
                Selected Accounts ({formData.selectedAccounts?.length || 0})
              </h3>
              {formData.selectedAccounts?.length > 0 ? (
                <div className="space-y-2">
                  <AccountAvatars accounts={formData.selectedAccounts} size="md" />
                  <div className="text-sm text-gray-500 dark:text-gray-400">
                    {formData.selectedAccounts.map(account => account.label || account.name).join(', ')}
                  </div>
                </div>
              ) : (
                <p className="text-gray-500 dark:text-gray-400">
                  No accounts selected
                </p>
              )}
            </div>
          </div>
        </div>

        {/* Success Message */}
        <div className="text-center p-6 bg-green-50 dark:bg-green-900/20 rounded-xl border border-green-200 dark:border-green-800">
          <CheckCircle className="w-12 h-12 text-green-600 dark:text-green-400 mx-auto mb-3" />
          <h4 className="text-lg font-semibold text-green-800 dark:text-green-300 mb-2">
            Ready to Launch!
          </h4>
          <p className="text-green-600 dark:text-green-400 text-sm">
            Your campaign is configured and ready to go. Click "Launch Campaign" to start.
          </p>
        </div>
      </div>
    </div>
  )
}

export default StepThree
