"use client"

import { cn } from "@/Lib/utils"
import useTranslate from "@/hooks/useTranslate";

export default function SettingsTabs({ activeTab, onTabChange }) {
  const t = useTranslate();
  const tabs = [
    { id: "basic-setting", label: t("Basic Setting") },
    { id: "theme-setting", label: t("Theme Setting") },
    { id: "logo-setting", label: t("Logo Setting") },
    { id: "logging", label: t("Logging") },
  ]

  return (
    <div className="px-6 pt-6 pb-4">
      <div className="flex space-x-8 rtl:space-x-reverse border-b border-gray-200">
        {tabs.map((tab) => (
          <button
            key={tab.id}
            className={cn(
              "pb-3 text-sm font-medium transition-colors relative",
              activeTab === tab.id ? "text-primary border-b-2 border-primary" : "text-bodyTextPrimary dark:text-neutral-400 hover:text-gray-700",
            )}
            onClick={() => onTabChange(tab.id)}
          >
            {tab.label}
          </button>
        ))}
      </div>
    </div>
  )
}
