"use client"

import { motion } from "framer-motion"
import { cn } from "@/Lib/utils"
import useTranslate from "@/hooks/useTranslate"

const tabIcons = {
  "basic-setting": (
    <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4" />
    </svg>
  ),
  "theme-setting": (
    <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01" />
    </svg>
  ),
  "logo-setting": (
    <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
    </svg>
  ),
  "logging": (
    <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
    </svg>
  ),
  "api-settings": (
    <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
    </svg>
  ),
  "backup": (
    <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
    </svg>
  ),
  "automation": (
    <svg className="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M13 10V3L4 14h7v7l9-11h-7z" />
    </svg>
  )
}

export default function PremiumSettingsTabs({ activeTab, onTabChange, tabs }) {
  const t = useTranslate()
  
  // Default tabs if not provided
  const defaultTabs = [
    { id: "basic-setting", label: t("Application Configuration"), icon: tabIcons["basic-setting"] },
    { id: "theme-setting", label: t("Interface & Design"), icon: tabIcons["theme-setting"] },
    { id: "logo-setting", label: t("Brand Management"), icon: tabIcons["logo-setting"] },
    { id: "automation", label: t("Automation & Cron Jobs"), icon: tabIcons["automation"] },
    { id: "logging", label: t("System Monitoring"), icon: tabIcons["logging"] },
    { id: "api-settings", label: t("API Integration"), icon: tabIcons["api-settings"] },
    { id: "backup", label: t("Data Management"), icon: tabIcons["backup"] },
  ]

  const tabsToRender = tabs || defaultTabs

  return (
    <div className="bg-white dark:bg-zinc-900 rounded-t-xl border-b border-gray-200 dark:border-zinc-800">
      <div className="px-0">
        {/* Tab Pills Style */}
        <div className="flex items-center space-x-1 p-1 bg-gray-100 dark:bg-zinc-800 rounded-lg lg:flex-row flex-col">
          {tabsToRender.map((tab, index) => (
            <motion.button
              key={tab.id}
              onClick={() => onTabChange(tab.id)}
              className={cn(
                "relative flex items-center space-x-2 px-4 py-2.5 rounded-lg text-sm font-medium transition-all duration-200 lg:w-auto w-full",
                activeTab === tab.id
                  ? "bg-white dark:bg-zinc-700 text-gray-900 dark:text-white shadow-sm"
                  : "text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white"
              )}
              whileHover={{ scale: activeTab === tab.id ? 1 : 1.02 }}
              whileTap={{ scale: 0.98 }}
            >
              {/* Active Indicator */}
              {activeTab === tab.id && (
                <motion.div
                  layoutId="activeTab"
                  className="absolute inset-0 bg-white dark:bg-zinc-700 rounded-lg shadow-sm"
                  initial={false}
                  transition={{
                    type: "spring",
                    stiffness: 500,
                    damping: 30
                  }}
                />
              )}

              {/* Tab Content */}
              <span className="relative z-10 flex items-center space-x-2">
                {tab.icon && (
                  <span className={cn(
                    "transition-colors",
                    activeTab === tab.id
                      ? "text-blue-600 dark:text-blue-400"
                      : "text-gray-400 dark:text-gray-500"
                  )}>
                    {tab.icon}
                  </span>
                )}
                <span>{tab.label}</span>
              </span>

              {/* Notification Dot */}
              {tab.hasNotification && (
                <span className="relative z-10 ml-2 w-2 h-2 bg-red-500 rounded-full animate-pulse" />
              )}
            </motion.button>
          ))}
        </div>
      </div>

      {/* Decorative Gradient Line */}
      <div className="h-px bg-gradient-to-r from-transparent via-gray-200 dark:via-zinc-700 to-transparent mt-4" />
    </div>
  )
}