<?php

namespace App\Models\Core;

use App\Models\CampaignPost;
use App\Models\UserFilePlatform;
use App\Traits\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class File extends Model
{
    use HasFactory, Filterable;

    protected $guarded = [];

    public function fileable()
    {
        return $this->morphTo();
    }

    public function platforms()
    {
        return $this->hasMany(UserFilePlatform::class);
    }

    public function campaignPosts()
    {
        return $this->belongsToMany(CampaignPost::class, 'campaign_post_files')
            ->withPivot('caption', 'order')
            ->withTimestamps();
    }

}
