<?php

namespace App\Models;

use App\Traits\Filterable;
use App\Traits\ModelAction;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Campaign extends Model
{
    use HasFactory, Filterable, ModelAction;

    protected $fillable = [
        'uid',
        'user_id',
        'workspace_id',
        'name',
        'description',
        'start_date',
        'end_date',
        'repeat_every',
        'repeat_end_date',
        'status',
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
        'repeat_end_date' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function posts()
    {
        return $this->hasMany(SocialPost::class);
    }
}
