<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TestEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $testMessage;
    public $fromEmail;
    public $fromName;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($message = null)
    {
        $this->testMessage = $message ?: 'This is a test email to verify that your SMTP configuration is working correctly. If you receive this email, your email settings have been configured successfully.';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('SMTP Configuration Test')
                    ->view('emails.test')
                    ->with([
                        'testMessage' => $this->testMessage,
                        'timestamp' => now()->format('Y-m-d H:i:s')
                    ]);
    }
}