<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SocialPostRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'accounts' => 'required|array',
            'accounts.*.account_id' => 'integer|exists:social_accounts,id',
            'accounts.*.platform_id' => 'integer|exists:platforms,id',
            'accounts.*.post_type' => 'string',

            'postTypes' => 'required|array',
            'postTypes.*' => 'string',

            'content' => 'required|string',

            'files' => 'nullable|array',
            'files.*.id' => 'nullable',
            'files.*.title' => 'required|string',
            'files.*.type' => 'required|string',
            'files.*.thumbnail' => 'nullable|string',
            'files.*.caption' => 'nullable|string',
            'files.*.alt' => 'nullable|string',
            'files.*.order' => 'nullable|integer',
            'files.*.isVideo' => 'nullable|boolean',

            'links' => 'nullable|array',
            'links.*.url' => 'required',
            'links.*.id' => 'nullable',

            'is_scheduled' => 'required|boolean',
            'scheduled_time' => 'nullable|date|after_or_equal:now',
            'is_draft' => 'required|boolean',
        ];
    }

    public function messages(): array
    {
        return [
            'account_ids.required' => 'Please select at least one account.',
            'accounts.*.account_id.*.integer' => 'Each account ID must be a valid number.',
            'accounts.*.account_id.*.exists' => 'One or more selected accounts do not exist.',

            'accounts.*.platform_id.required' => 'Please select at least one platform.',
            'accounts.*.platform_id.*.integer' => 'Each platform ID must be a valid number.',
            'accounts.*.platform_id.*.exists' => 'One or more selected platforms are invalid.',

            'postTypes.required' => 'Please choose a post type for each platform.',
            'postTypes.*.string' => 'Each post type must be valid text.',

            'content.required' => 'Your post content cannot be empty.',
            'content.string' => 'Post content must be text.',

            'files.array' => 'Files must be sent as an array.',
            'files.*.id.required' => 'Each file must have an ID.',
            'files.*.id.integer' => 'Each file ID must be a number.',
            'files.*.title.required' => 'Each file must have a title.',
            'files.*.type.required' => 'Each file must specify a type.',
            'files.*.size.required' => 'Each file must include its size.',
            'files.*.platform.required' => 'Each file must be linked to a platform.',
            'files.*.isVideo.boolean' => 'The isVideo field must be true or false.',

            'links.array' => 'Links must be sent as an array.',
            'links.*.url.required' => 'Each link must include a URL.',
            'links.*.url.url' => 'Each link must be a valid URL.',
            'links.*.id' => 'Each link ID must be valid.',
        ];
    }

}
