<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PostTemplateUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id'            => 'required|exists:post_templates,id',
            'content'       => 'required|string',
            'link'          => 'nullable|string',
            'platform_id'   => 'nullable|integer|exists:platforms,id',

            'files'         => 'nullable|array',
            'files.*.id'    => 'required|integer|exists:files,id',
            'files.*.caption' => 'nullable|string|max:255',
            'files.*.alt'   => 'nullable|string|max:255',
            'files.*.order' => 'nullable|integer|min:0',
        ];
    }
}
