<?php
namespace App\Http\Controllers;
use App\Http\Services\TwoFactorService;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Inertia\Inertia;
use Inertia\Response;
class TwoFactorController extends Controller
{
    public function __construct(protected TwoFactorService $twoFactorService){}


   /**
     * Summary of index
     * @return \Inertia\Response
     */
    public function index(): Response
    {
        return Inertia::render('ProfileSettings',[
            'title'     => translate("2FA Configuration"),
            'component' => 'TwoFAConfig',
            'setup_data' => $this->twoFactorService->getSetupData()
        ]);
    }


    /**
     * Summary of verify
     * @param \Illuminate\Http\Request $request
     * @return RedirectResponse
     */
    public function verify(Request $request): RedirectResponse
    {
        $request->validate([
            'code'    => ['required','digits:6']
        ]);
       return $this->twoFactorService->verify2faCode($request->input('code'));
    }


    /**
     * Summary of disable
     * @param \Illuminate\Http\Request $request
     * @return RedirectResponse
     */
    public function disable(Request $request): RedirectResponse
    {
        return $this->twoFactorService->disable2fa($request);
    }


    
    /**
     * Summary of regenerateRecoveryCodes
     * @param \Illuminate\Http\Request $request
     * @return RedirectResponse
     */
    public function regenerateRecoveryCodes(Request $request): RedirectResponse
    {
        return $this->twoFactorService->saveNewRecoveryCode($request);
    }
}