import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import react from '@vitejs/plugin-react';
import path from 'path';

export default defineConfig({
  base: '/build/',
  plugins: [
    laravel({
      input: [
        'resources/js/app.jsx',
        'resources/css/app.css',
      ],
      refresh: true,
      publicDirectory: path.resolve(__dirname, 'public'),
      hotFile: path.resolve(__dirname, 'public/hot'),
      buildDirectory: 'public/build',
    }),
    react(),
  ],
  build: {
    outDir: path.resolve(__dirname, 'public/build'),
    emptyOutDir: true,
  },
  resolve: {
    alias: {
      '@': path.resolve(__dirname, 'resources/js'),
    },
  }
});
