<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;
use App\Services\LicenseService;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// Schedule license verification to run weekly
Schedule::call(function () {
    $licenseService = app(LicenseService::class);
    $licenseService->periodicVerification();
})->weekly()->sundays()->at('03:00')->name('license-verification');
