"use client"

import AppLayout from "@/Layouts/AppLayout"
import { useState } from "react"
import useTranslate from "@/hooks/useTranslate"
import { Tabs, TabsList, TabsTrigger } from "@/Components/UI/Tabs"
import EngagementChart from "@/Components/Analytics/EngagementChart"
import PerformanceSummary from "@/Components/Analytics/PerformanceSummary"
import StatisticByGender from "@/Components/Analytics/StatisticByGender"
import FeedPostCard from "@/Components/Feed/PostCard"
import CommentBox from "@/Components/Feed/CommentBox"
import { router } from "@inertiajs/react"

export default function PostPreview({ post, AnalyticalData }) {
  const t = useTranslate()
  const [activeTab, setActiveTab] = useState("overview")
  const [activePlatform, setActivePlatform] = useState("facebook")

  const breadcrumbs = [{ label: "Home", href: "user.home" }, { label: "Preview" }]

  const handleTab = (value) => {
    setActiveTab(value)
    // You can add backend route calls here based on the tab
    // router.get(route('user.post.preview'), { tab: value }, { preserveState: true })
  }

  const handleAddComment = async (commentData) => {
    try {
      // Make API call to save the comment
      await router.post(
        route("user.post.comment.store"),
        {
          post_id: post?.id,
          content: commentData.content,
          image: commentData.image,
          parent_id: commentData.parentId || null,
        },
        {
          preserveState: true,
          onSuccess: () => {
            // Comment added successfully
          },
          onError: (errors) => {
            console.error("[v0] Error adding comment:", errors)
          },
        },
      )
    } catch (error) {
      console.error("[v0] Error adding comment:", error)
    }
  }

  return (
    <>
      <AppLayout breadcrumbs={breadcrumbs}>
        <div className="flex-1 p-6 overflow-auto bg-gray-50 dark:bg-black">
          {/* Header */}
          <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
            <div className="space-y-1">
              <h1 className="text-2xl dark:text-gray-200 font-bold ">{t("Preview")}</h1>
              <p className="text-gray-500 dark:text-gray-200">
                {t("Make sure to stay engaged with your social media platforms!")}
              </p>
            </div>
          </div>

          <div className="mb-6">
            <div className="flex gap-1">
              <Tabs value={activeTab} onValueChange={handleTab} className="space-y-6">
                <TabsList className="inline-flex bg-white rounded-lg p-1 shadow-sm gap-1 ltr:flex-row rtl:flex-row-reverse">
                  <TabsTrigger
                    value="overview"
                    className="data-[state=active]:bg-gradient-to-r data-[state=active]:from-primary data-[state=active]:to-secondary data-[state=active]:text-white data-[state=active]:shadow-sm rounded-md px-4 py-2 text-sm font-medium transition-colors"
                  >
                    {t("Overview")}
                  </TabsTrigger>
                  <TabsTrigger
                    value="feed"
                    className="data-[state=active]:bg-gradient-to-r data-[state=active]:from-primary data-[state=active]:to-secondary data-[state=active]:text-white data-[state=active]:shadow-sm rounded-md px-4 py-2 text-sm font-medium transition-colors"
                  >
                    {t("Feed")}
                  </TabsTrigger>
                </TabsList>
              </Tabs>
            </div>
          </div>

          <div className="space-y-6">
            {activeTab === "overview" && (
              <div className="space-y-6">
                <PerformanceSummary
                  platform={activePlatform}
                  data={AnalyticalData.postSummary}
                  metrics={AnalyticalData.postSummary.metrics}
                />
                <div className="grid grid-cols-3 gap-6">
                  <div className="col-span-2">
                    <EngagementChart platform={activePlatform} data={AnalyticalData.engagementAnalytics} />
                  </div>
                  <div className="col-span-1">
                    <StatisticByGender data={AnalyticalData.statisticByGender} />
                  </div>
                </div>
              </div>
            )}

            {activeTab === "feed" && (
              <div className="grid grid-cols-3 gap-6">
                <div className="col-span-1">
                  <FeedPostCard post={post} />
                </div>
                <div className="col-span-2">
                  <CommentBox postId={post?.id} account = {post?.account} onAddComment={handleAddComment} />
                </div>
              </div>
            )}
          </div>
        </div>
      </AppLayout>
    </>
  )
}
