"use client"

import { Link } from "@inertiajs/react"
import { motion } from "framer-motion"
import { cn } from "@/Lib/utils"

export default function PremiumBreadcrumb({ 
  items = [], 
  className = "",
  separator = "chevron", // chevron, slash, arrow, dot
  ...props 
}) {
  const separators = {
    chevron: (
      <svg className="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5l7 7-7 7" />
      </svg>
    ),
    slash: <span className="text-gray-400 px-1">/</span>,
    arrow: <span className="text-gray-400 px-1">→</span>,
    dot: <span className="text-gray-400 px-1">•</span>
  }

  return (
    <nav className={cn("flex items-center space-x-2", className)} {...props}>
      {items.map((item, index) => (
        <motion.div
          key={index}
          initial={{ opacity: 0, x: -10 }}
          animate={{ opacity: 1, x: 0 }}
          transition={{ delay: index * 0.1 }}
          className="flex items-center"
        >
          {index > 0 && (
            <span className="mx-2">
              {separators[separator] || separators.chevron}
            </span>
          )}
          
          {item.href && index < items.length - 1 ? (
            <Link
              href={item.href}
              className="flex items-center space-x-2 text-sm font-medium text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors"
            >
              {item.icon && (
                <span className="text-gray-400">
                  {item.icon}
                </span>
              )}
              <span>{item.label}</span>
            </Link>
          ) : (
            <span className="flex items-center space-x-2 text-sm font-medium text-gray-900 dark:text-white">
              {item.icon && (
                <span className="text-gray-600 dark:text-gray-400">
                  {item.icon}
                </span>
              )}
              <span>{item.label}</span>
            </span>
          )}
        </motion.div>
      ))}
    </nav>
  )
}