"use client"; // if using Next.js / Inertia React

import { useEffect, useState } from "react";
import { motion } from "framer-motion";

export default function Preloader({ siteName, siteLogo }) {
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const timer = setTimeout(() => {
      setLoading(false);
    }, 2000);

    return () => clearTimeout(timer);
  }, []);

  if (!loading) return null;

  return (
    <div className="preloader">
      {/* Glowing Circles */}
      <div className="text-container">
        <img src={siteLogo} alt="Site Logo" className="w-24 h-24" />
        {/* Animate site name */}
        <motion.h1
          initial={{ y: 50, opacity: 0 }}
          animate={{ y: 0, opacity: 1 }}
          transition={{ duration: 1, delay: 0.5 }}
          className="text-4xl font-bold text-white"
        >
          {siteName}
        </motion.h1>
      </div>
    </div>
  );
}
