import { Card, CardContent } from "@/Components/UI/Card"
import PlatformIcon from "@/Components/UI/PlatformIcon"
import { Button } from "@/Components/UI/Button"
import { Users, Eye, FileText, TrendingUp, Settings } from "lucide-react"
import EngagementStat from "./EngagementStat"
import AccountAvatars from "@/Components/Platform/AccountAvatars"
import { Link } from '@inertiajs/react'
import { route } from "ziggy-js"
import useTranslate from "@/hooks/useTranslate"
import { motion } from "framer-motion";

export default function PlatformCard({ platform, viewMode, onAddAccount }) {
    const stats = [
        { icon: Users, value: platform.stats.followers, label: "Followers" },
        { icon: Eye, value: platform.stats.reach, label: "Reach" },
        { icon: FileText, value: platform.stats.posts, label: "Posts" },
        { icon: TrendingUp, value: platform.stats.engagements, label: "Engagements" },
    ]

    if (viewMode === "list") {
        return (
            <motion.div
                initial={{ opacity: 0, y: 15 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.4, ease: "easeOut" }}
            >
                <Card className="w-full bg-white dark:bg-zinc-900 shadow-sm hover:shadow-md transition-shadow duration-200 border border-gray-100 dark:border-zinc-800">
                    <CardContent className="lg:p-6 p-4">
                        <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
                            <div className="flex items-center flex-wrap gap-4">
                                <div className="p-2 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-zinc-800 dark:to-zinc-700 rounded-xl">
                                    <PlatformIcon slug={platform.slug} size={40} />
                                </div>
                                <div>
                                    <span className="text-xl font-semibold text-gray-900 dark:text-white">{platform.name}</span>
                                    <p className="text-sm text-gray-500 dark:text-gray-400 mt-1">Last sync: {platform.lastSync}</p>
                                </div>
                                <Button
                                    variant="ghost"
                                    className="h-9 text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white rounded-lg border border-gray-200 dark:border-zinc-800 hover:bg-gray-50 dark:hover:bg-zinc-800 transition-all duration-200"
                                    onClick={() => onAddAccount && onAddAccount(platform)}
                                >
                                    Add Account +
                                </Button>
                                <AccountAvatars accounts={platform.accounts} size="sm" />
                            </div>
                        </div>

                        <div className="flex items-center justify-between flex-wrap gap-4">
                            <div className="flex items-center lg:flex-nowrap flex-wrap gap-4">
                                {stats.map((stat, index) => (
                                    <EngagementStat
                                        key={stat.label}
                                        icon={stat.icon}
                                        value={stat.value}
                                        label={stat.label}
                                        layout="horizontal"
                                        showBorder={index > 0}
                                    />
                                ))}
                            </div>

                            <div className="flex items-center flex-wrap gap-3">
                                <Link href={route("user.platform.setting", platform.id)}>
                                    <Button className="bg-gradient-to-r from-primary to-secondary hover:from-secondary hover:to-primary text-white px-6 py-2 shadow-sm hover:shadow-md transition-all duration-200">
                                        <Settings className="w-4 h-4 mr-2" />
                                        Settings
                                    </Button>
                                </Link>
                                <Link href={route("user.platform.accounts", platform.id)}>
                                    <Button variant="outline" className="">
                                        <Users className="w-4 h-4 mr-2" />
                                        View Accounts ({platform.accountCount})
                                    </Button>
                                </Link>
                            </div>
                        </div>
                    </CardContent>
                </Card>
            </motion.div>
        )
    }

    return (
        <motion.div
            initial={{ opacity: 0, y: 15 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ 
                duration: 0.4, 
                ease: "easeOut"
            }}
            className="h-full"
        >
            <Card className="bg-white dark:bg-zinc-900 shadow-sm hover:shadow-md border border-gray-100 dark:border-zinc-800 transition-shadow duration-200 h-full">
                <CardContent className="p-6 flex flex-col h-full">
                    <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
                        <div className="flex items-center flex-wrap gap-4">
                            <div className="p-3 bg-gradient-to-br from-primary/10 to-secondary/10 dark:from-zinc-800 dark:to-zinc-700 rounded-xl">
                                <PlatformIcon slug={platform.slug} size={40} />
                            </div>
                            <div>
                                <h2 className="text-base lg:text-lg font-semibold bg-gradient-to-r from-gray-900 to-gray-700 dark:from-white dark:to-gray-200 bg-clip-text text-transparent">
                                    {platform.name}
                                </h2>
                                <p className="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                    Last sync: {platform.lastSync}
                                </p>
                            </div>
                        </div>

                        <div className="flex items-center gap-3">
                            <AccountAvatars accounts={platform.accounts} size="md" />
                            <Button
                                variant="ghost"
                                size="sm"
                                className="text-gray-600 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white rounded-lg border border-gray-200 dark:border-zinc-800 hover:bg-gray-50 dark:hover:bg-zinc-800 transition-all duration-200"
                                onClick={() => onAddAccount && onAddAccount(platform)}
                            >
                                Add Account +
                            </Button>
                        </div>
                    </div>

                    <div className="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-6 flex-1">
                        {stats.map((stat, index) => (
                            <div key={stat.label}>
                                <EngagementStat
                                    icon={stat.icon}
                                    value={stat.value}
                                    label={stat.label}
                                    layout="vertical"
                                    showBorder={false}
                                />
                            </div>
                        ))}
                    </div>

                    {/* Action Buttons */}
                    <div className="border-t border-gray-200 dark:border-zinc-800 pt-6 mt-auto">
                        <div className="flex gap-3 flex-wrap">
                            <Link href={route("user.platform.setting", platform.id)} className="flex-1">
                                <Button className="w-full bg-gradient-to-r from-primary to-secondary hover:from-secondary hover:to-primary text-white shadow-sm hover:shadow-md transition-all duration-200">
                                    <Settings className="w-4 h-4 mr-2" />
                                    Settings
                                </Button>
                            </Link>

                            <Link href={route("user.platform.accounts", platform.id)} className="flex-1">
                                <Button variant="outline" className="w-full">
                                    <Users className="w-4 h-4 mr-2" />
                                    View Accounts ({platform.accountCount})
                                </Button>
                            </Link>
                        </div>
                    </div>
                </CardContent>
            </Card>
        </motion.div>
    )
}
