export default function EngagementStat({
  icon: Icon,
  value,
  label,
  layout = "vertical",
  showBorder = false,
}) {
  if (layout === "horizontal") {
    return (
      <div className={` ${showBorder ? "border-l border-gray-200 dark:border-zinc-700 lg:pl-8 pl-4" : ""}`}>
        <div className="flex items-center gap-2.5 mb-1">
          <Icon className="w-4 h-4 text-gray-400" />
          <span className="lg:text-lg text-base font-bold text-gray-900 dark:text-gray-50">{value}</span>
        </div>
        <p className="text-xs text-gray-500">{label}</p>
      </div>
    )
  }

  return (
    <div className={` ${showBorder ? "border-l border-gray-200 pl-4" : ""}`}>
      <div className="flex items-center space-x-2 mb-1">
        <Icon className="h-4 w-4 text-gray-400" />
        <span className="font-semibold text-gray-900 dark:text-gray-100">{value}</span>
      </div>
      <span className="text-sm text-gray-600 dark:text-zinc-400">{label}</span>
    </div>
  )
}
