import { Link } from '@inertiajs/react'
import { UserX } from "lucide-react"

const EmptyPage = ({
    heading = "No Items Found",
    subheading = "Get started by creating your first item.",
    buttonTitle = "Get Started",
    buttonUrl = "#",
    icon: Icon = UserX,
}) => {
    return (
        <div className="flex-1 flex items-center justify-center min-h-[60vh]">
            <div className="text-center max-w-md mx-auto p-8">
                {/* Blue bordered container */}
                <div className="rounded-lg p-8">
                    {/* Icon container with dotted border */}
                    <div className="mx-auto w-20 h-20 border-2 border-dashed border-gray-300 rounded-lg flex items-center justify-center mb-6 bg-gray-50">
                        <Icon className="w-8 h-8 text-gray-400" />
                    </div>

                    {/* Heading */}
                    <h2 className="text-xxl font-semibold text-gray-900 mb-3">{heading}</h2>

                    {/* Subheading */}
                    <p className="text-gray-500 text-sm mb-6 leading-relaxed">{subheading}</p>

                    {/* Action Button */}
                    <a
                        href={buttonUrl}
                        className="inline-flex items-center px-6 py-2.5 bg-gradient-to-r from-primary to-secondary text-white hover:from-sky-600 hover:to-cyan-600 text-sm font-medium rounded-lg transition-colors duration-200"
                    >
                        + {buttonTitle}
                    </a>
                </div>
            </div>
        </div>
    )
}

export default EmptyPage
