"use client"

import { Badge } from "@/Components/UI/Badge"
import { Button } from "@/Components/UI/Button"
import { Edit, Users, FileText, Heart, MoreVertical } from "lucide-react"
import AccountAvatars from "@/Components/Platform/AccountAvatars"

export default function CampaignCard({ campaign, onRowAction, calculateProgress }) {
  return (
    <div className="bg-white dark:bg-zinc-900 rounded-lg border border-gray-200 dark:border-zinc-800 p-6 hover:shadow-md transition-shadow">
      {/* Header with campaign name, status, and menu */}
      <div className="flex items-start justify-between mb-4">
        <div className="flex-1">
          <h3 className="font-semibold text-gray-900 mb-2">{campaign.name}</h3>
          <Badge
            variant={
              campaign.status === "sent" ? "default" : campaign.status === "failed" ? "destructive" : "secondary"
            }
            className={
              campaign.status === "sent"
                ? "bg-blue-100 text-blue-800 hover:bg-blue-100"
                : campaign.status === "failed"
                  ? "bg-red-100 text-red-800 hover:bg-red-100"
                  : "bg-gray-100 text-gray-800 hover:bg-gray-100"
            }
          >
            {campaign.status === "sent" ? "Sent" : campaign.status === "failed" ? "Failed" : "Draft"}
          </Badge>
        </div>
        
      </div>

      {/* Date */}
      <p className="text-sm text-gray-500 mb-4">
        {new Date(campaign.created_at).toLocaleDateString("en-US", {
          day: "numeric",
          month: "long",
          year: "numeric",
          hour: "2-digit",
          minute: "2-digit",
          hour12: true,
        })}
      </p>

      {/* Platform avatars */}
      <div className="flex -space-x-2 mb-6">
        {campaign.accounts && campaign.accounts.length > 0 ? (
          <AccountAvatars accounts={campaign.accounts} size="sm" />
        ) : (
          <span className="text-gray-400 text-sm">No accounts</span>
        )}
      </div>

      {/* Metrics with line separators */}
      <div className="flex items-center justify-between flex-wrap gap-4 mb-6">
        <div className="flex-1 text-left">
          <div className="flex items-center justify-start mb-1">
            <Users className="w-4 h-4 text-gray-400 mr-1" />
            <span className="font-semibold text-gray-900">{campaign.reach}</span>
          </div>
          <p className="text-xs text-gray-500">Reach</p>
        </div>

        <div className="w-px h-8 bg-gray-200 mx-4"></div>

        <div className="flex-1 text-left">
          <div className="flex items-center justify-start mb-1">
            <FileText className="w-4 h-4 text-gray-400 mr-1" />
            <span className="font-semibold text-gray-900">{campaign.posts_count}</span>
          </div>
          <p className="text-xs text-gray-500">Posts</p>
        </div>

        <div className="w-px h-8 bg-gray-200 mx-4"></div>

        <div className="flex-1 text-left">
          <div className="flex items-center justify-start mb-1">
            <Heart className="w-4 h-4 text-gray-400 mr-1" />
            <span className="font-semibold text-gray-900">{campaign.engagement}</span>
          </div>
          <p className="text-xs text-gray-500">Engagements</p>
        </div>
      </div>


      {/* Progress bar */}
      <div className="mb-6">
        <div className="flex items-center space-x-3">
          <div className="flex-1 bg-gray-200 dark:bg-zinc-800 rounded-full h-2 overflow-hidden">
            <div
              className="h-full bg-gradient-to-r from-blue-500 to-teal-400 rounded-full transition-all duration-300"
              style={{ width: `${calculateProgress(campaign.start_date, campaign.end_date)}%` }}
            />
          </div>
        </div>
      </div>

      {/* Action buttons */}
      <div className="flex gap-3">
        <Button
          onClick={() => onRowAction("edit", campaign)}
          className="flex-1 bg-gradient-to-r from-blue-500 to-teal-400 hover:from-blue-600 hover:to-teal-500 text-white"
        >
          <Edit className="w-4 h-4 mr-2" />
          Edit Campaign
        </Button>
        <Button
          onClick={() => onRowAction("view_analytics", campaign)}
          variant="outline"
          className="flex-1 border-gray-300 text-gray-700 hover:bg-gray-50 bg-transparent"
        >
          <Users className="w-4 h-4 mr-2" />
          View Analytics
        </Button>
      </div>
    </div>
  )
}
