<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $allPermissions = collect(config('settings.role_permissions'))
            ->flatten()
            ->toArray();

        $roles = [
            [
                'name' => 'Owner',
                'permissions' => $allPermissions,
            ],
            [
                'name' => 'Admin',
                'permissions' => [
                    'view_language',
                    'create_language',
                    'update_language',
                    'view_staff',
                    'create_staff',
                    'update_staff',
                ],
            ],
            [
                'name' => 'Editor',
                'permissions' => [
                    'view_language',
                    'translate_language',
                ],
            ],
            [
                'name' => 'Viewer',
                'permissions' => [
                    'view_language',
                    'view_staff',
                ],
            ],
        ];

        foreach ($roles as $role) {
            Role::updateOrCreate(
                ['name' => $role['name']],
                ['permissions' => $role['permissions']]
            );
        }
    }
}
