<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Core\Setting;
use Illuminate\Support\Str;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add new preloader settings
        $newSettings = [
            [
                'uid' => Str::uuid(),
                'key' => 'preloader_show_on_home',
                'value' => '1', // Show on home route by default
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'uid' => Str::uuid(),
                'key' => 'preloader_show_on_first_login',
                'value' => '1', // Show on first device login by default
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'uid' => Str::uuid(),
                'key' => 'preloader_duration',
                'value' => '3000', // Duration in milliseconds
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($newSettings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Setting::whereIn('key', [
            'preloader_show_on_home',
            'preloader_show_on_first_login',
            'preloader_duration'
        ])->delete();
    }
};