<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::create('social_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('uid', 100)->unique()->nullable();
            $table->foreignId('platform_id')->constrained('platforms')->cascadeOnDelete();
            $table->foreignId('workspace_id')->nullable()->constrained('workspaces')->nullOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('label', 155)->nullable();
            $table->string('name', 155)->nullable();
            $table->string('account_id', 191)->nullable();
            $table->text('account_information')->nullable();
            $table->unsignedBigInteger('followers')->default(0);
            $table->enum('status', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::true->status())
                ->index()
                ->comment('Active: 1, Inactive: 0');
            $table->enum('is_official', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::true->status())
                ->index()
                ->comment('Official: 1, Unofficial: 0');
            $table->enum('is_connected', array_values(StatusEnum::toArray()))
                ->default(StatusEnum::true->status())
                ->index()
                ->comment('Connected: 1, Disconnected: 0');

            $table->tinyInteger('account_type')->default('1')->comment('0: Profile, 1: Page, 2: Group');

            $table->string('details', 255)->nullable();

            $table->text('token')->nullable();
            $table->dateTime('access_token_expire_at')->nullable();

            $table->text('refresh_token')->nullable();
            $table->dateTime('refresh_token_expire_at')->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->unique(['platform_id', 'account_id']);
            $table->index(['workspace_id', 'platform_id']);

        });
        Schema::enableForeignKeyConstraints();

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('social_accounts');
        Schema::enableForeignKeyConstraints();

    }
};
