<?php

namespace Database\Factories;

use App\Enums\AccountType;
use App\Enums\StatusEnum;
use App\Models\SocialAccount;
use App\Models\Platform;
use App\Models\User;
use App\Models\Workspace;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class SocialAccountFactory extends Factory
{
    protected $model = SocialAccount::class;

    public function definition(): array
    {
        $accountId = Str::random(10);

        $accountInformation = [
            'id' => $accountId,
            'account_id' => $accountId,
            'label' => $this->faker->company,
            'name' => $this->faker->name,
            'avatar' => $this->faker->imageUrl(200, 200, 'business'),
            'email' => $this->faker->safeEmail,
            'token' => Str::random(120),
            'access_token_expire_at' => now()->addMonths(2),
            'refresh_token' => Str::random(120),
            'refresh_token_expire_at' => now()->addMonths(3),

        ];

        return [
            'uid' => Str::uuid(),
            'platform_id' => Platform::inRandomOrder()->first()->id ?? Platform::factory(),
            'workspace_id' => Workspace::inRandomOrder()->first()->id ?? Workspace::factory(),
            'user_id' => User::where('owner', StatusEnum::true->status())->first()?->id
                ?? User::factory()->create()->id,

            'label' => $accountInformation['label'],
            'name' => $accountInformation['name'],
            'account_id' => $accountId,
            'account_information' => json_encode($accountInformation),
            'followers' => rand(100, 500),
            'status' => 1,
            'is_official' => 1,
            'is_connected' => 1,
            'account_type' => $this->faker->randomElement(AccountType::cases()),

            'details' => $this->faker->sentence,
            'token' => $accountInformation['token'],
            'access_token_expire_at' => $accountInformation['access_token_expire_at'],
            'refresh_token' => $accountInformation['refresh_token'],
            'refresh_token_expire_at' => $accountInformation['refresh_token_expire_at'],
        ];
    }
}
