<?php
namespace App\Http\Utility;

use App\Enums\StatusEnum;
use App\Models\Admin\SmsGateway;
use App\Models\Core\Template as CoreTemplate;
use Twilio\Rest\Client;

use Exception;

class SendSMS{



	public static function smsNotification(string $template, array $tmpCodes = [] , object | null $userinfo = null , SmsGateway $gateway = null ) :array
    {

		if(!$gateway){
			$gateway = \App\Models\Core\SmsGateway::where('default',StatusEnum::true->status())->first();
		}

        $template = CoreTemplate::where('slug', $template)->first();

		$gatewayCode = [

            "101NEX"        => "nexmo",
            "102TWI"        => "twilio",
            "103BIRD"       => "messageBird",
            "104INFO"       => "infobip",
        ];

		$messages = notificationMessage($tmpCodes ,$template->sms_body,$userinfo);


		if(isset($gatewayCode[$gateway->code])){
            return self::{$gatewayCode[$gateway->code]}($gateway->credential,  @$userinfo->phone, $messages);
        }

		return [
            "status"  => false,
            "message" => translate('Gateway Not Found')
        ];
    }



	/**
	 * send twilio sms
	 *
	 * @param object $credential
	 * @param string $to
	 * @param string $message
	 * @return array
	 */
	public static function twilio(object $credential,string $to,string $message):array
	{
		$status = true;
        $responseMessage = translate("Sms Send Successfully");
        try{
            $twilioNumber = $credential->from_number;
            $client = new Client($credential->account_sid, $credential->auth_token);
            $create = $client->messages->create('+'.$to, [
                'from' => $twilioNumber,
                'body' => $message
            ]);


        }catch (\Exception $e) {

	        $status          = false;
            $responseMessage = $e->getMessage();
        }



		return [
            "status"  => $status,
            "message" => $responseMessage
        ];
	}






}
