<?php

namespace App\Http\Middleware;

use App\Enums\StatusEnum;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Response;

class Demo
{
    /**
     * Routes that are always ignored (allowed) in demo mode
     */
    protected array $ignoreRoutes = [
        'admin.system.update.init',
        'admin.system.update',
    ];

    /**
     * Routes that are restricted in demo mode
     * Add route names here to block data modification
     */

     
    protected array $restrictedRoutes = [ 
        'user.setting.store', 
        'user.setting.logo.store', 
        'profile.update',
        'password.update',
        'user.update',
        'settings.update',
        'language.update',
        'user.workspace.store',
        'user.workspace.update',
        'user.workspace.destroy',
        'user.setting.data.export',
        'user.setting.backup.create',
        'user.setting.backup.restore',
        'user.setting.backup.delete',
        'user.setting.maintenance.run',
        'user.cron.system-cleanup',
        'user.cron.backup-run',
        'user.2fa.verify',
        'user.2fa.disable',
        'user.2fa.regenerate.code',
        'user.access-control.store',
        'user.access-control.update',
        'user.access-control.delete',
        'user.access-control.bulk',
        'user.role.store',
        'user.role.update',
        'user.role.delete',
        'user.role.bulk',
        'user.role.edit',
        'user.language.store',
        'user.language.status.update',
        'user.language.delete',
        'user.language.bulk',
        'user.language.make.default',
        'user.language.translation',
        'user.language.translation.add',
        'user.language.auto-translate', 
        'user.system.update.init',
        'user.system.update',
        'user.platform.account.delete',
        'user.platform.account.bulk',
        'user.platform.account.status.update',
        'user.gallery.store',
        'user.gallery.update',
        'user.gallery.delete',
        'user.gallery.bulk',
        'user.gallery.download',
        'user.file.store',
        'user.file.update',
        'user.file.delete',
        'user.file.bulk',
    ];

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        try {
            // Check if demo mode is enabled
            if (strtolower(env('APP_MODE')) !== 'demo') {
                return $next($request);
            }

            $currentRoute = Route::currentRouteName();

            // Allow ignored routes
            if (in_array($currentRoute, $this->ignoreRoutes)) {
                return $next($request);
            }

            // Check if route is restricted
            $isRestricted = in_array($currentRoute, $this->restrictedRoutes) ||
                $request->routeIs('*.update*') ||
                $request->routeIs('*.destroy*') ||
                $request->routeIs('*.delete*') ||
                $request->routeIs('*.bulk*') ||
                $request->routeIs('*.send*');

            // Block POST, PUT, PATCH, DELETE methods on restricted routes
            if ($isRestricted && in_array($request->method(), ['POST', 'PUT', 'PATCH', 'DELETE'])) {
                $message = 'Data modification is not allowed in demo mode';

                if ($request->header('X-Inertia')) {
                    session()->flash('error', $message);
                    return back(303);
                }

                if ($request->expectsJson() || $request->isXmlHttpRequest()) {
                    return response()->json(response_status($message, 'error'), 403);
                }

                return back()->with(response_status($message, 'error'));
            }

            return $next($request);
        } catch (\Throwable $th) {
            return $next($request);
        }
    }
}
